// Copyright 2008, 2011 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.corelib.base.AbstractConditional;

/**
 * A close relative of the {@link org.apache.tapestry5.corelib.components.If} component that inverts the meaning of its
 * test. This is easier than an {@link org.apache.tapestry5.corelib.components.If} component with the negate parameter set to {@code true}.
 * 
 * @tapestrydoc
 */
public class Unless extends AbstractConditional
{
    /**
     * If true, then the body of the component is omitted. If false, the body is rendered.
     */
    @Parameter(required = true)
    private boolean test;

    /**
     * @return test parameter inverted
     */
    protected boolean test()
    {
        return !test;
    }
}
