/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.AfterRenderBody;
import org.apache.tapestry5.annotations.AfterRenderTemplate;
import org.apache.tapestry5.annotations.BeforeRenderBody;
import org.apache.tapestry5.annotations.BeforeRenderTemplate;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.CleanupRender;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.Condition;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.runtime.Event;
import org.apache.tapestry5.services.TransformConstants;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class RenderPhaseMethodWorker
implements ComponentClassTransformWorker2 {
    private final Map<Class<? extends Annotation>, MethodDescription> annotationToDescription = CollectionFactory.newMap();
    private final Map<String, Class<? extends Annotation>> nameToAnnotation = CollectionFactory.newCaseInsensitiveMap();
    private final Set<Class<? extends Annotation>> reverseAnnotations = CollectionFactory.newSet((Object[])new Class[]{AfterRenderBody.class, AfterRenderTemplate.class, AfterRender.class, CleanupRender.class});
    private final Set<MethodDescription> lifecycleMethods = CollectionFactory.newSet();
    private InstructionBuilderCallback JUST_RETURN;

    public RenderPhaseMethodWorker() {
        this.annotationToDescription.put(SetupRender.class, TransformConstants.SETUP_RENDER_DESCRIPTION);
        this.annotationToDescription.put(BeginRender.class, TransformConstants.BEGIN_RENDER_DESCRIPTION);
        this.annotationToDescription.put(BeforeRenderTemplate.class, TransformConstants.BEFORE_RENDER_TEMPLATE_DESCRIPTION);
        this.annotationToDescription.put(BeforeRenderBody.class, TransformConstants.BEFORE_RENDER_BODY_DESCRIPTION);
        this.annotationToDescription.put(AfterRenderBody.class, TransformConstants.AFTER_RENDER_BODY_DESCRIPTION);
        this.annotationToDescription.put(AfterRenderTemplate.class, TransformConstants.AFTER_RENDER_TEMPLATE_DESCRIPTION);
        this.annotationToDescription.put(AfterRender.class, TransformConstants.AFTER_RENDER_DESCRIPTION);
        this.annotationToDescription.put(CleanupRender.class, TransformConstants.CLEANUP_RENDER_DESCRIPTION);
        for (Map.Entry<Class<? extends Annotation>, MethodDescription> me : this.annotationToDescription.entrySet()) {
            this.nameToAnnotation.put(me.getValue().methodName, me.getKey());
            this.lifecycleMethods.add(me.getValue());
        }
        this.JUST_RETURN = new InstructionBuilderCallback(){

            public void doBuild(InstructionBuilder builder) {
                builder.returnDefaultValue();
            }
        };
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        Map<Class, List<PlasticMethod>> methods = this.mapRenderPhaseAnnotationToMethods(plasticClass);
        for (Class renderPhaseAnnotation : methods.keySet()) {
            this.mapMethodsToRenderPhase(plasticClass, support.isRootTransformation(), renderPhaseAnnotation, methods.get(renderPhaseAnnotation));
            model.addRenderPhase(renderPhaseAnnotation);
        }
    }

    private void mapMethodsToRenderPhase(final PlasticClass plasticClass, final boolean isRoot, Class annotationType, List<PlasticMethod> methods) {
        final MethodDescription interfaceMethodDescription = this.annotationToDescription.get(annotationType);
        PlasticMethod interfaceMethod = plasticClass.introduceMethod(interfaceMethodDescription);
        final boolean reverse = this.reverseAnnotations.contains(annotationType);
        final Flow orderedMethods = reverse ? (Flow)F.flow(methods).reverse() : F.flow(methods);
        interfaceMethod.changeImplementation(new InstructionBuilderCallback(){

            private void addSuperCall(InstructionBuilder builder) {
                builder.loadThis().loadArguments().invokeSpecial(plasticClass.getSuperClassName(), interfaceMethodDescription);
            }

            private void invokeMethod(InstructionBuilder builder, PlasticMethod method) {
                builder.loadArgument(1);
                builder.loadConstant((Object)method.getMethodIdentifier());
                builder.invoke(Event.class, Void.TYPE, "setMethodDescription", new Class[]{String.class});
                builder.loadThis();
                if (method.getParameters().size() > 0) {
                    builder.loadArgument(0);
                }
                builder.invokeVirtual(method);
                if (!method.isVoid()) {
                    builder.boxPrimitive(method.getDescription().returnType);
                    builder.loadArgument(1).swap();
                    builder.invoke(Event.class, Boolean.TYPE, "storeResult", new Class[]{Object.class});
                    builder.when(Condition.NON_ZERO, RenderPhaseMethodWorker.this.JUST_RETURN);
                }
            }

            public void doBuild(InstructionBuilder builder) {
                if (!reverse && !isRoot) {
                    this.addSuperCall(builder);
                    builder.loadArgument(1).invoke(Event.class, Boolean.TYPE, "isAborted", new Class[0]);
                    builder.when(Condition.NON_ZERO, RenderPhaseMethodWorker.this.JUST_RETURN);
                }
                for (PlasticMethod invokedMethod : orderedMethods) {
                    this.invokeMethod(builder, invokedMethod);
                }
                if (reverse && !isRoot) {
                    this.addSuperCall(builder);
                }
                builder.returnDefaultValue();
            }
        });
    }

    private Map<Class, List<PlasticMethod>> mapRenderPhaseAnnotationToMethods(PlasticClass plasticClass) {
        Map map = CollectionFactory.newMap();
        Flow<PlasticMethod> matches = this.matchAllMethodsNotOverriddenFromBaseClass(plasticClass);
        for (PlasticMethod method : matches) {
            this.addMethodToRenderPhaseCategoryMap(map, method);
        }
        return map;
    }

    private void addMethodToRenderPhaseCategoryMap(Map<Class, List<PlasticMethod>> map, PlasticMethod method) {
        Class categorized = this.categorizeMethod(method);
        if (categorized != null) {
            this.validateAsRenderPhaseMethod(method);
            InternalUtils.addToMapList(map, (Object)categorized, (Object)method);
        }
    }

    private Class categorizeMethod(PlasticMethod method) {
        for (Class<? extends Annotation> annotationClass : this.annotationToDescription.keySet()) {
            if (!method.hasAnnotation(annotationClass)) continue;
            return annotationClass;
        }
        return this.nameToAnnotation.get(method.getDescription().methodName);
    }

    private void validateAsRenderPhaseMethod(PlasticMethod method) {
        String[] argumentTypes = method.getDescription().argumentTypes;
        switch (argumentTypes.length) {
            case 0: {
                break;
            }
            case 1: {
                if (argumentTypes[0].equals(MarkupWriter.class.getName())) break;
            }
            default: {
                throw new RuntimeException(String.format("Method %s is not a valid render phase method: it should take no parameters, or take a single parameter of type MarkupWriter.", method.toString()));
            }
        }
    }

    private Flow<PlasticMethod> matchAllMethodsNotOverriddenFromBaseClass(PlasticClass plasticClass) {
        return (Flow)F.flow((Collection)plasticClass.getMethods()).filter((Predicate)new Predicate<PlasticMethod>(){

            public boolean accept(PlasticMethod method) {
                return !method.isOverride() && !RenderPhaseMethodWorker.this.lifecycleMethods.contains(method.getDescription());
            }
        });
    }
}

