/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Worker;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.internal.transform.PropertyValueProviderWorker;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldHandle;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.plastic.PropertyAccessType;
import org.apache.tapestry5.plastic.PropertyValueProvider;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.TransformConstants;
import org.apache.tapestry5.services.javascript.Initialization;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class ImportWorker
implements ComponentClassTransformWorker2 {
    private static final String FIELD_PREFIX = "importedAssets_";
    private final JavaScriptSupport javascriptSupport;
    private final SymbolSource symbolSource;
    private final AssetSource assetSource;
    private final ResourceChangeTracker resourceChangeTracker;
    private final boolean multipleClassLoaders;
    private final PropertyValueProviderWorker propertyValueProviderWorker;
    private final Worker<Asset> importLibrary = new Worker<Asset>(){

        public void work(Asset asset) {
            ImportWorker.this.javascriptSupport.importJavaScriptLibrary(asset);
        }
    };
    private final Worker<Asset> importStylesheet = new Worker<Asset>(){

        public void work(Asset asset) {
            ImportWorker.this.javascriptSupport.importStylesheet(asset);
        }
    };
    private final Mapper<String, String> expandSymbols = new Mapper<String, String>(){

        public String map(String element) {
            return ImportWorker.this.symbolSource.expandSymbols(element);
        }
    };

    public ImportWorker(JavaScriptSupport javascriptSupport, SymbolSource symbolSource, AssetSource assetSource, ResourceChangeTracker resourceChangeTracker, PropertyValueProviderWorker propertyValueProviderWorker) {
        this.javascriptSupport = javascriptSupport;
        this.symbolSource = symbolSource;
        this.assetSource = assetSource;
        this.resourceChangeTracker = resourceChangeTracker;
        this.propertyValueProviderWorker = propertyValueProviderWorker;
        this.multipleClassLoaders = Boolean.valueOf(symbolSource.valueForSymbol("tapestry.production-mode")) == false && Boolean.valueOf(symbolSource.valueForSymbol("tapestry.multiple-classloaders")) != false;
    }

    @Override
    public void transform(PlasticClass componentClass, TransformationSupport support, MutableComponentModel model) {
        this.resourceChangeTracker.setCurrentClassName(model.getComponentClassName());
        HashSet<PlasticUtils.FieldInfo> fieldInfos = this.multipleClassLoaders ? new HashSet<PlasticUtils.FieldInfo>() : null;
        this.processClassAnnotationAtSetupRenderPhase(componentClass, model, fieldInfos);
        List methods = componentClass.getMethodsWithAnnotation(Import.class);
        for (PlasticMethod m : methods) {
            this.decorateMethod(componentClass, model, m, fieldInfos);
        }
        if (this.multipleClassLoaders && !fieldInfos.isEmpty()) {
            this.propertyValueProviderWorker.add(componentClass, fieldInfos);
        }
        this.resourceChangeTracker.clearCurrentClassName();
    }

    private void processClassAnnotationAtSetupRenderPhase(PlasticClass componentClass, MutableComponentModel model, Set<PlasticUtils.FieldInfo> fieldInfos) {
        Import annotation = (Import)componentClass.getAnnotation(Import.class);
        if (annotation != null) {
            PlasticMethod setupRender = componentClass.introduceMethod(TransformConstants.SETUP_RENDER_DESCRIPTION);
            this.decorateMethod(componentClass, model, setupRender, annotation, fieldInfos);
            model.addRenderPhase(SetupRender.class);
        }
    }

    private void decorateMethod(PlasticClass componentClass, MutableComponentModel model, PlasticMethod method, Set<PlasticUtils.FieldInfo> fieldInfos) {
        Import annotation = (Import)method.getAnnotation(Import.class);
        this.decorateMethod(componentClass, model, method, annotation, fieldInfos);
    }

    private void decorateMethod(PlasticClass componentClass, MutableComponentModel model, PlasticMethod method, Import annotation, Set<PlasticUtils.FieldInfo> fieldInfos) {
        this.importStacks(method, annotation.stack());
        this.importLibraries(componentClass, model, method, annotation.library(), fieldInfos);
        this.importStylesheets(componentClass, model, method, annotation.stylesheet(), fieldInfos);
        this.importModules(method, annotation.module());
    }

    private void importStacks(PlasticMethod method, String[] stacks) {
        if (stacks.length != 0) {
            method.addAdvice(this.createImportStackAdvice(stacks));
        }
    }

    private MethodAdvice createImportStackAdvice(final String[] stacks) {
        return new MethodAdvice(){

            public void advise(MethodInvocation invocation) {
                for (String stack : stacks) {
                    ImportWorker.this.javascriptSupport.importStack(stack);
                }
                invocation.proceed();
            }
        };
    }

    private void importModules(PlasticMethod method, String[] moduleNames) {
        if (moduleNames.length != 0) {
            method.addAdvice(this.createImportModulesAdvice(moduleNames));
        }
    }

    private MethodAdvice createImportModulesAdvice(String[] moduleNames) {
        final ArrayList<ModuleImport> moduleImports = new ArrayList<ModuleImport>(moduleNames.length);
        for (String name : moduleNames) {
            int colonx = name.indexOf(58);
            String moduleName = colonx < 0 ? name : name.substring(0, colonx);
            String functionName = colonx < 0 ? null : name.substring(colonx + 1);
            moduleImports.add(new ModuleImport(moduleName, functionName));
        }
        return new MethodAdvice(){

            public void advise(MethodInvocation invocation) {
                for (ModuleImport moduleImport : moduleImports) {
                    moduleImport.apply(ImportWorker.this.javascriptSupport);
                }
                invocation.proceed();
            }
        };
    }

    private void importLibraries(PlasticClass plasticClass, MutableComponentModel model, PlasticMethod method, String[] paths, Set<PlasticUtils.FieldInfo> fieldInfos) {
        this.decorateMethodWithOperation(plasticClass, model, method, paths, this.importLibrary, fieldInfos);
    }

    private void importStylesheets(PlasticClass plasticClass, MutableComponentModel model, PlasticMethod method, String[] paths, Set<PlasticUtils.FieldInfo> fieldInfos) {
        this.decorateMethodWithOperation(plasticClass, model, method, paths, this.importStylesheet, fieldInfos);
    }

    private void decorateMethodWithOperation(PlasticClass componentClass, MutableComponentModel model, PlasticMethod method, String[] paths, Worker<Asset> operation, Set<PlasticUtils.FieldInfo> fieldInfos) {
        if (paths.length == 0) {
            return;
        }
        String[] expandedPaths = this.expandPaths(paths);
        String fieldName = this.getFieldName(method);
        PlasticField assetListField = componentClass.introduceField(Asset[].class, fieldName);
        if (this.multipleClassLoaders) {
            fieldInfos.add(PlasticUtils.toFieldInfo((PlasticField)assetListField));
            assetListField.createAccessors(PropertyAccessType.READ_ONLY);
        }
        this.initializeAssetsFromPaths(expandedPaths, assetListField, model.getLibraryName());
        this.addMethodAssetOperationAdvice(method, assetListField.getHandle(), operation);
    }

    private String getFieldName(PlasticMethod method) {
        StringBuilder builder = new StringBuilder(FIELD_PREFIX);
        builder.append(method.getDescription().methodName);
        if (this.multipleClassLoaders) {
            builder.append("_");
            builder.append(method.getPlasticClass().getClassName().replace('.', '_'));
        }
        return builder.toString();
    }

    private String[] expandPaths(String[] paths) {
        return (String[])F.flow((Object[])paths).map(this.expandSymbols).toArray(String.class);
    }

    private void initializeAssetsFromPaths(final String[] expandedPaths, PlasticField assetsField, final String libraryName) {
        assetsField.injectComputed((ComputedValue)new ComputedValue<Asset[]>(){

            public Asset[] get(InstanceContext context) {
                ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
                return ImportWorker.this.convertPathsToAssetArray(resources, expandedPaths, libraryName);
            }
        });
    }

    private Asset[] convertPathsToAssetArray(final ComponentResources resources, String[] assetPaths, final String libraryName) {
        return (Asset[])F.flow((Object[])assetPaths).map((Mapper)new Mapper<String, Asset>(){

            public Asset map(String assetPath) {
                return ImportWorker.this.assetSource.getComponentAsset(resources, assetPath, libraryName);
            }
        }).toArray(Asset.class);
    }

    private void addMethodAssetOperationAdvice(PlasticMethod method, final FieldHandle access, final Worker<Asset> operation) {
        final String className = method.getPlasticClass().getClassName();
        final String fieldName = this.getFieldName(method);
        method.addAdvice(new MethodAdvice(){

            public void advise(MethodInvocation invocation) {
                invocation.proceed();
                Object instance = invocation.getInstance();
                Object[] assets = (Asset[])(ImportWorker.this.multipleClassLoaders ? PropertyValueProvider.get((Object)instance, (String)fieldName) : access.get(instance));
                if (ImportWorker.this.multipleClassLoaders) {
                    ImportWorker.this.resourceChangeTracker.setCurrentClassName(className);
                }
                F.flow((Object[])assets).each(operation);
                if (ImportWorker.this.multipleClassLoaders) {
                    ImportWorker.this.resourceChangeTracker.clearCurrentClassName();
                }
            }
        });
    }

    public static interface ImportWorkerDataProvider {
        public Asset[] get(int var1);
    }

    class ModuleImport {
        final String moduleName;
        final String functionName;

        ModuleImport(String moduleName, String functionName) {
            this.moduleName = moduleName;
            this.functionName = functionName;
        }

        void apply(JavaScriptSupport javaScriptSupport) {
            Initialization initialization = javaScriptSupport.require(this.moduleName);
            if (this.functionName != null) {
                initialization.invoke(this.functionName);
            }
        }
    }
}

