/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.internal.services.assets.StreamableResourceImpl;
import org.apache.tapestry5.services.assets.AssetChecksumGenerator;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.StreamableResource;

public class CompressedStreamableResource
extends StreamableResourceImpl {
    public CompressedStreamableResource(StreamableResource base, AssetChecksumGenerator assetChecksumGenerator) throws IOException {
        super(base.getDescription(), base.getContentType(), CompressionStatus.COMPRESSED, base.getLastModified(), CompressedStreamableResource.compressContent(base), assetChecksumGenerator, base.getResponseCustomizer());
        assert (base.getCompression() == CompressionStatus.COMPRESSABLE);
    }

    private static BytestreamCache compressContent(StreamableResource resource) throws IOException {
        ByteArrayOutputStream compressed = new ByteArrayOutputStream(resource.getSize());
        BufferedOutputStream compressor = new BufferedOutputStream(new GZIPOutputStream(compressed));
        resource.streamTo(compressor);
        ((OutputStream)compressor).close();
        return new BytestreamCache(compressed);
    }
}

