/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.test;

import java.io.File;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.tapestry5.test.ServletContainerRunner;
import org.apache.tapestry5.test.TapestryRunnerConstants;

public class TomcatRunner
implements ServletContainerRunner {
    private final String description;
    private final int port;
    private final int sslPort;
    private Tomcat tomcatServer;

    public TomcatRunner(String webappFolder, String contextPath, int port, int sslPort) throws Exception {
        this.port = port;
        this.sslPort = sslPort;
        String expandedPath = this.expand(webappFolder);
        this.description = String.format("<TomcatRunner:%s:%s/%s (%s)", contextPath, port, sslPort, expandedPath);
        this.tomcatServer = new Tomcat();
        String tmpDir = System.getProperty("java.io.tmpdir");
        String fileSeparator = System.getProperty("file.separator");
        if (!tmpDir.endsWith(fileSeparator)) {
            tmpDir = tmpDir + fileSeparator;
        }
        this.tomcatServer.setBaseDir(tmpDir + "tomcat");
        this.tomcatServer.addWebapp("/", expandedPath);
        this.tomcatServer.getConnector().setAllowTrace(true);
        File keystoreFile = new File(TapestryRunnerConstants.MODULE_BASE_DIR, "src/test/conf/keystore");
        if (keystoreFile.exists()) {
            Connector https = new Connector();
            https.setPort(sslPort);
            https.setProperty("keystore", keystoreFile.getPath());
            https.setProperty("keypass", "tapestry");
            this.tomcatServer.getService().addConnector(https);
        }
        this.tomcatServer.start();
    }

    @Override
    public void stop() {
        System.out.printf("Stopping Tomcat instance on port %d/%d\n", this.port, this.sslPort);
        try {
            this.tomcatServer.stop();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error stopping Tomcat instance: " + ex.toString(), ex);
        }
        System.out.println("Tomcat instance has stopped.");
    }

    public String toString() {
        return this.description;
    }

    protected String expand(String moduleLocalPath) {
        File path = new File(moduleLocalPath);
        if (path.isAbsolute() && path.isDirectory()) {
            return moduleLocalPath;
        }
        return new File(TapestryRunnerConstants.MODULE_BASE_DIR, moduleLocalPath).getPath();
    }
}

