/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.javascript;

import java.util.List;
import java.util.Map;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;

public class JavaScriptStackSourceImpl
implements JavaScriptStackSource {
    private final Map<String, JavaScriptStack> configuration;

    public JavaScriptStackSourceImpl(Map<String, JavaScriptStack> configuration) {
        this.configuration = configuration;
    }

    @Override
    public JavaScriptStack getStack(String name) {
        JavaScriptStack stack = this.findStack(name);
        if (stack == null) {
            throw new UnknownValueException(String.format("No JavaScriptStack with name '%s'.", name), new AvailableValues("Configured JavaScript stacks", this.configuration));
        }
        return stack;
    }

    @Override
    public JavaScriptStack findStack(String name) {
        return this.configuration.get(name);
    }

    @Override
    public List<String> getStackNames() {
        return F.flow(this.configuration.keySet()).sort().toList();
    }

    @Override
    public JavaScriptStack findStackForJavaScriptLibrary(Resource resource) {
        for (JavaScriptStack stack : this.configuration.values()) {
            for (Asset libraryAsset : stack.getJavaScriptLibraries()) {
                if (!libraryAsset.getResource().equals(resource)) continue;
                return stack;
            }
        }
        return null;
    }
}

