/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.IMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;

public class MapToZero
extends AMapToData {
    private static final long serialVersionUID = -8065234231282619923L;
    private final int _size;

    public MapToZero(int size) {
        super(1);
        this._size = size;
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.ZERO;
    }

    @Override
    public int getIndex(int n) {
        return 0;
    }

    @Override
    public void fill(int v) {
    }

    @Override
    public long getInMemorySize() {
        return MapToZero.getInMemorySize(0);
    }

    public static long getInMemorySize(int dataLength) {
        return 20L;
    }

    @Override
    public long getExactSizeOnDisk() {
        return 5L;
    }

    @Override
    public void set(int n, int v) {
    }

    @Override
    public void set(int l, int u, int off, AMapToData tm) {
    }

    @Override
    public int setAndGet(int n, int v) {
        return 0;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void replace(int v, int r) {
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.ZERO.ordinal());
        out.writeInt(this._size);
    }

    protected static MapToZero readFields(DataInput in) throws IOException {
        return new MapToZero(in.readInt());
    }

    @Override
    public int getUpperBoundValue() {
        return 0;
    }

    @Override
    public int[] getCounts(int[] ret) {
        ret[0] = this.size();
        return ret;
    }

    @Override
    public void preAggregateDDC_DDCSingleCol(AMapToData tm, double[] td, double[] v) {
        int sz = this.size();
        for (int r = 0; r < sz; ++r) {
            v[0] = v[0] + td[tm.getIndex(r)];
        }
    }

    @Override
    public void preAggregateDDC_DDCMultiCol(AMapToData tm, IDictionary td, double[] v, int nCol) {
        int sz = this.size();
        for (int r = 0; r < sz; ++r) {
            td.addToEntry(v, tm.getIndex(r), 0, nCol);
        }
    }

    @Override
    public void copyInt(int[] d, int start, int end) {
    }

    @Override
    public void copyBit(MapToBit d) {
    }

    @Override
    public AMapToData resize(int unique) {
        return this;
    }

    @Override
    public int countRuns() {
        return 1;
    }

    @Override
    public AMapToData slice(int l, int u) {
        return new MapToZero(u - l);
    }

    @Override
    public AMapToData append(AMapToData t) {
        if (t instanceof MapToZero) {
            return new MapToZero(this._size + t.size());
        }
        throw new NotImplementedException("Not implemented append on Bit map different type");
    }

    @Override
    public AMapToData appendN(IMapToDataGroup[] d) {
        int p = 0;
        boolean allZ = true;
        for (IMapToDataGroup gd : d) {
            AMapToData m = gd.getMapToData();
            p += m.size();
            if (m instanceof MapToZero) continue;
            allZ = false;
        }
        if (!allZ) {
            throw new RuntimeException("Not supported combining different types of map");
        }
        return new MapToZero(p);
    }

    @Override
    public boolean equals(AMapToData e) {
        return e instanceof MapToZero && this._size == ((MapToZero)e)._size;
    }
}

