/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class RightIndex
extends Lop {
    public static final String OPCODE = "rightIndex";
    private boolean forLeftIndexing = false;
    private AggBinaryOp.SparkAggType _aggtype = AggBinaryOp.SparkAggType.MULTI_BLOCK;

    public RightIndex(Lop input, Lop rowL, Lop rowU, Lop colL, Lop colU, Types.DataType dt, Types.ValueType vt, Types.ExecType et, boolean forleft) {
        super(Lop.Type.RightIndex, dt, vt);
        this.init(input, rowL, rowU, colL, colU, dt, vt, et, forleft);
    }

    public RightIndex(Lop input, Lop rowL, Lop rowU, Lop colL, Lop colU, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        super(Lop.Type.RightIndex, dt, vt);
        this.init(input, rowL, rowU, colL, colU, dt, vt, et, false);
    }

    public RightIndex(Lop input, Lop rowL, Lop rowU, Lop colL, Lop colU, Types.DataType dt, Types.ValueType vt, AggBinaryOp.SparkAggType aggtype, Types.ExecType et) {
        super(Lop.Type.RightIndex, dt, vt);
        this._aggtype = aggtype;
        this.init(input, rowL, rowU, colL, colU, dt, vt, et, false);
    }

    private void init(Lop inputMatrix, Lop rowL, Lop rowU, Lop colL, Lop colU, Types.DataType dt, Types.ValueType vt, Types.ExecType et, boolean forleft) {
        this.addInput(inputMatrix);
        this.addInput(rowL);
        this.addInput(rowU);
        this.addInput(colL);
        this.addInput(colU);
        inputMatrix.addOutput(this);
        rowL.addOutput(this);
        rowU.addOutput(this);
        colL.addOutput(this);
        colU.addOutput(this);
        this.lps.setProperties(this.inputs, et);
        this.forLeftIndexing = forleft;
    }

    private String getOpcode() {
        if (this.forLeftIndexing) {
            return "rightIndexForLeft";
        }
        return OPCODE;
    }

    @Override
    public AggBinaryOp.SparkAggType getAggType() {
        return this._aggtype;
    }

    @Override
    public String getInstructions(String input, String rowl, String rowu, String coll, String colu, String output) {
        StringBuilder sb = InstructionUtils.getStringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepScalarInputOperand(rowl));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepScalarInputOperand(rowu));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(3).prepScalarInputOperand(coll));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(4).prepScalarInputOperand(colu));
        sb.append("\u00b0");
        sb.append(output);
        sb.append("\u00b7");
        sb.append((Object)this.getDataType());
        sb.append("\u00b7");
        sb.append((Object)this.getValueType());
        if (this.getExecType() == Types.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append((Object)this._aggtype);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getOpcode();
    }
}

