/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.functionobjects.OffsetColumnIndex;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.FrameAppendCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ListAppendRemoveCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MatrixAppendCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarAppendCPInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;

public abstract class AppendCPInstruction
extends BinaryCPInstruction {
    protected final AppendType _type;

    protected AppendCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, AppendType type, String opcode, String istr) {
        super(CPInstruction.CPType.Append, op, in1, in2, out, opcode, istr);
        this._type = type;
    }

    public static AppendCPInstruction parseInstruction(String str) {
        AppendType type;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5, 4);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[parts.length - 2]);
        boolean cbind = Boolean.parseBoolean(parts[parts.length - 1]);
        AppendType appendType = in1.getDataType() != Types.DataType.MATRIX && in1.getDataType() != Types.DataType.FRAME ? (in1.getDataType() == Types.DataType.LIST ? AppendType.LIST : AppendType.STRING) : (type = cbind ? AppendType.CBIND : AppendType.RBIND);
        if (!opcode.equalsIgnoreCase("append") && !opcode.equalsIgnoreCase("remove")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a AppendCPInstruction: " + str);
        }
        ReorgOperator op = new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1));
        if (type == AppendType.STRING) {
            return new ScalarAppendCPInstruction(op, in1, in2, out, type, opcode, str);
        }
        if (type == AppendType.LIST) {
            return new ListAppendRemoveCPInstruction(op, in1, in2, out, type, opcode, str);
        }
        if (in1.getDataType() == Types.DataType.MATRIX) {
            return new MatrixAppendCPInstruction(op, in1, in2, out, type, opcode, str);
        }
        return new FrameAppendCPInstruction(op, in1, in2, out, type, opcode, str);
    }

    public AppendType getAppendType() {
        return this._type;
    }

    public static enum AppendType {
        CBIND,
        RBIND,
        STRING,
        LIST;

    }
}

