/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.CompressionStatistics;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CLALibAppend {
    private static final Log LOG = LogFactory.getLog((String)CLALibAppend.class.getName());

    public static MatrixBlock append(MatrixBlock left, MatrixBlock right) {
        Pair<MatrixBlock, CompressionStatistics> x;
        if (left.isEmpty() && right instanceof CompressedMatrixBlock) {
            return CLALibAppend.appendLeftEmpty(left, (CompressedMatrixBlock)right);
        }
        if (right.isEmpty() && left instanceof CompressedMatrixBlock) {
            return CLALibAppend.appendRightEmpty((CompressedMatrixBlock)left, right);
        }
        int m = left.getNumRows();
        int n = left.getNumColumns() + right.getNumColumns();
        if (!(left instanceof CompressedMatrixBlock) && m > 1000) {
            LOG.warn((Object)"Compressing left for append operation");
            x = CompressedMatrixBlockFactory.compress(left);
            if (((CompressionStatistics)x.getRight()).getRatio() > 3.0) {
                left = (MatrixBlock)x.getLeft();
            }
        }
        if (!(right instanceof CompressedMatrixBlock) && m > 1000) {
            LOG.warn((Object)"Compressing right for append operation");
            x = CompressedMatrixBlockFactory.compress(right);
            if (((CompressionStatistics)x.getRight()).getRatio() > 3.0) {
                right = (MatrixBlock)x.getLeft();
            }
        }
        if (!(left instanceof CompressedMatrixBlock) || !(right instanceof CompressedMatrixBlock)) {
            return CLALibAppend.uc(left).append(CLALibAppend.uc(right), null);
        }
        CompressedMatrixBlock leftC = (CompressedMatrixBlock)left;
        CompressedMatrixBlock rightC = (CompressedMatrixBlock)right;
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        ret = CLALibAppend.appendColGroups(ret, leftC.getColGroups(), rightC.getColGroups(), leftC.getNumColumns());
        return ret;
    }

    private static MatrixBlock appendRightEmpty(CompressedMatrixBlock left, MatrixBlock right) {
        int m = left.getNumRows();
        int n = left.getNumColumns() + right.getNumColumns();
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        ArrayList<AColGroup> newGroup = new ArrayList<AColGroup>(1);
        newGroup.add(ColGroupEmpty.generate(right.getNumColumns(), right.getNumRows()));
        ret = CLALibAppend.appendColGroups(ret, left.getColGroups(), newGroup, left.getNumColumns());
        return ret;
    }

    private static MatrixBlock appendLeftEmpty(MatrixBlock left, CompressedMatrixBlock right) {
        int m = left.getNumRows();
        int n = left.getNumColumns() + right.getNumColumns();
        CompressedMatrixBlock ret = new CompressedMatrixBlock(m, n);
        ArrayList<AColGroup> newGroup = new ArrayList<AColGroup>(1);
        newGroup.add(ColGroupEmpty.generate(left.getNumColumns(), left.getNumRows()));
        ret = CLALibAppend.appendColGroups(ret, newGroup, right.getColGroups(), left.getNumColumns());
        return ret;
    }

    private static CompressedMatrixBlock appendColGroups(CompressedMatrixBlock ret, List<AColGroup> left, List<AColGroup> right, int leftNumCols) {
        AColGroup tmp;
        ret.allocateColGroupList(new ArrayList<AColGroup>(left.size() + right.size()));
        long nnz = 0L;
        for (AColGroup group : left) {
            tmp = group.copy();
            ret.getColGroups().add(tmp);
            nnz += group.getNumberNonZeros();
        }
        for (AColGroup group : right) {
            tmp = group.copy();
            tmp.shiftColIndices(leftNumCols);
            ret.getColGroups().add(tmp);
            nnz += group.getNumberNonZeros();
        }
        ret.setNonZeros(nnz);
        return ret;
    }

    private static MatrixBlock uc(MatrixBlock mb) {
        return CompressedMatrixBlock.getUncompressed(mb);
    }
}

