/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.concurrent.Future;
import org.apache.sysds.lops.LopProperties;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.fed.UnaryFEDInstruction;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;

public class AggregateUnaryFEDInstruction
extends UnaryFEDInstruction {
    private AggregateUnaryFEDInstruction(AggregateUnaryOperator auop, CPOperand in, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.AggregateUnary, auop, in, out, opcode, istr);
    }

    public static AggregateUnaryFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        AggregateUnaryOperator aggun = InstructionUtils.parseBasicAggregateUnaryOperator(opcode);
        if (InstructionUtils.getExecType(str) == LopProperties.ExecType.SPARK) {
            str = InstructionUtils.replaceOperand(str, 4, "-1");
        }
        return new AggregateUnaryFEDInstruction(aggun, in1, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        AggregateUnaryOperator aop = (AggregateUnaryOperator)this._optr;
        MatrixObject in = ec.getMatrixObject(this.input1);
        FederationMap map = in.getFedMapping();
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1}, new long[]{in.getFedMapping().getID()});
        FederatedRequest fr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr1.getID());
        FederatedRequest fr3 = map.cleanup(this.getTID(), fr1.getID());
        Future<FederatedResponse>[] tmp = map.execute(this.getTID(), fr1, fr2, fr3);
        if (this.output.isScalar()) {
            ec.setVariable(this.output.getName(), FederationUtils.aggScalar(aop, tmp));
        } else {
            ec.setMatrixOutput(this.output.getName(), FederationUtils.aggMatrix(aop, tmp, map));
        }
    }
}

