/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC1;
import org.apache.sysds.runtime.compress.colgroup.ColGroupOLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupRLE;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.DataConverter;

public class ColGroupConverter {
    public static ColGroup copyColGroup(ColGroup group) {
        ColGroup ret = null;
        int[] colIndices = Arrays.copyOf(group.getColIndices(), group.getNumCols());
        if (group instanceof ColGroupUncompressed) {
            ColGroupUncompressed in = (ColGroupUncompressed)group;
            ret = new ColGroupUncompressed(colIndices, in._numRows, in.getData());
        } else if (group instanceof ColGroupRLE) {
            ColGroupRLE in = (ColGroupRLE)group;
            ret = new ColGroupRLE(colIndices, in._numRows, in.hasZeros(), in._dict, in.getBitmaps(), in.getBitmapOffsets());
        } else if (group instanceof ColGroupOLE) {
            ColGroupOLE in = (ColGroupOLE)group;
            ret = new ColGroupOLE(colIndices, in._numRows, in.hasZeros(), in._dict, in.getBitmaps(), in.getBitmapOffsets());
        } else if (group instanceof ColGroupDDC1) {
            ColGroupDDC1 in = (ColGroupDDC1)group;
            ret = new ColGroupDDC1(colIndices, in._numRows, in._dict, in.getData(), in._zeros);
        } else {
            throw new RuntimeException("Using '" + group.getClass() + "' instance of ColGroup not fully supported");
        }
        return ret;
    }

    public static double[] getDenseVector(MatrixBlock vector) {
        return DataConverter.convertToDoubleVector(vector, false);
    }

    public static MatrixBlock getUncompressedColBlock(ColGroup group) {
        return group instanceof ColGroupUncompressed ? ((ColGroupUncompressed)group).getData() : new ColGroupUncompressed(Arrays.asList(group)).getData();
    }
}

