/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopProperties;

public class PMMJ
extends Lop {
    public static final String OPCODE = "pmm";
    private CacheType _cacheType = null;
    private int _numThreads = 1;

    public PMMJ(Lop pminput, Lop rightinput, Lop nrow, Types.DataType dt, Types.ValueType vt, boolean partitioned, boolean emptyBlocks, LopProperties.ExecType et) {
        super(Lop.Type.PMMJ, dt, vt);
        this.addInput(pminput);
        this.addInput(rightinput);
        this.addInput(nrow);
        pminput.addOutput(this);
        rightinput.addOutput(this);
        nrow.addOutput(this);
        this._cacheType = partitioned ? CacheType.LEFT_PART : CacheType.LEFT;
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "Operation = PMMJ";
    }

    @Override
    public String getInstructions(String input_index1, String input_index2, String input_index3, String output_index) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input_index2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepInputOperand(input_index3));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append((Object)this._cacheType);
        } else if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    public void setNumThreads(int k) {
        this._numThreads = k;
    }

    public static enum CacheType {
        LEFT,
        LEFT_PART;

    }
}

