/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class RepMat
extends Lop {
    public static final String OPCODE = "rep";
    private boolean _repCols = true;

    public RepMat(Lop input1, Lop input2, boolean repCols, Expression.DataType dt, Expression.ValueType vt) {
        super(Lop.Type.RepMat, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this._repCols = repCols;
        boolean breaksAlignment = true;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.GMR);
        this.lps.addCompatibility(JobType.DATAGEN);
        this.lps.setProperties(this.inputs, LopProperties.ExecType.MR, LopProperties.ExecLocation.Map, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return "Operation = RepMat";
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int output_index) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input_index1));
        sb.append("\u00b0");
        sb.append(this._repCols);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output_index));
        return sb.toString();
    }
}

