/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysml.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class CSVReblockSPInstruction
extends UnarySPInstruction {
    private int _brlen;
    private int _bclen;
    private boolean _hasHeader;
    private String _delim;
    private boolean _fill;
    private double _fillValue;

    protected CSVReblockSPInstruction(Operator op, CPOperand in, CPOperand out, int br, int bc, boolean hasHeader, String delim, boolean fill, double fillValue, String opcode, String instr) {
        super(SPInstruction.SPType.CSVReblock, op, in, out, opcode, instr);
        this._brlen = br;
        this._bclen = bc;
        this._hasHeader = hasHeader;
        this._delim = delim;
        this._fill = fill;
        this._fillValue = fillValue;
    }

    public static CSVReblockSPInstruction parseInstruction(String str) {
        String opcode = InstructionUtils.getOpCode(str);
        if (!opcode.equals("csvrblk")) {
            throw new DMLRuntimeException("Incorrect opcode for CSVReblockSPInstruction:" + opcode);
        }
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        int brlen = Integer.parseInt(parts[3]);
        int bclen = Integer.parseInt(parts[4]);
        boolean hasHeader = Boolean.parseBoolean(parts[5]);
        String delim = parts[6];
        boolean fill = Boolean.parseBoolean(parts[7]);
        double fillValue = Double.parseDouble(parts[8]);
        return new CSVReblockSPInstruction(null, in, out, brlen, bclen, hasHeader, delim, fill, fillValue, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        CacheableData<?> obj = sec.getCacheableData(this.input1.getName());
        MetaDataFormat iimd = (MetaDataFormat)obj.getMetaData();
        if (iimd.getInputInfo() != InputInfo.CSVInputInfo) {
            throw new DMLRuntimeException("The given InputInfo is not implemented for CSVReblockSPInstruction:" + iimd.getInputInfo());
        }
        MatrixCharacteristics mcIn = sec.getMatrixCharacteristics(this.input1.getName());
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        mcOut.set(mcIn.getRows(), mcIn.getCols(), this._brlen, this._bclen);
        if (Recompiler.checkCPReblock(sec, this.input1.getName())) {
            if (this.input1.getDataType() == Expression.DataType.MATRIX) {
                Recompiler.executeInMemoryMatrixReblock(sec, this.input1.getName(), this.output.getName());
            } else if (this.input1.getDataType() == Expression.DataType.FRAME) {
                Recompiler.executeInMemoryFrameReblock(sec, this.input1.getName(), this.output.getName());
            }
            return;
        }
        Object out = null;
        if (this.input1.getDataType() == Expression.DataType.MATRIX) {
            out = this.processMatrixCSVReblockInstruction(sec, mcOut);
        } else if (this.input1.getDataType() == Expression.DataType.FRAME) {
            out = this.processFrameCSVReblockInstruction(sec, mcOut, ((FrameObject)obj).getSchema());
        }
        sec.setRDDHandleForVariable(this.output.getName(), (JavaPairRDD<?, ?>)out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
    }

    protected JavaPairRDD<MatrixIndexes, MatrixBlock> processMatrixCSVReblockInstruction(SparkExecutionContext sec, MatrixCharacteristics mcOut) {
        JavaPairRDD<?, ?> in = sec.getRDDHandleForMatrixObject(sec.getMatrixObject(this.input1), InputInfo.CSVInputInfo);
        return RDDConverterUtils.csvToBinaryBlock(sec.getSparkContext(), in, mcOut, this._hasHeader, this._delim, this._fill, this._fillValue);
    }

    protected JavaPairRDD<Long, FrameBlock> processFrameCSVReblockInstruction(SparkExecutionContext sec, MatrixCharacteristics mcOut, Expression.ValueType[] schema) {
        JavaPairRDD<?, ?> in = sec.getRDDHandleForFrameObject(sec.getFrameObject(this.input1), InputInfo.CSVInputInfo);
        return FrameRDDConverterUtils.csvToBinaryBlock(sec.getSparkContext(), in, mcOut, schema, this._hasHeader, this._delim, this._fill, this._fillValue);
    }
}

