/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class Ternary
extends Lop {
    private final OperationType _type;

    public Ternary(OperationType op, Lop input1, Lop input2, Lop input3, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.Ternary, dt, vt);
        this._type = op;
        this.init(input1, input2, input3, et);
    }

    private void init(Lop input1, Lop input2, Lop input3, LopProperties.ExecType et) {
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        if (et == LopProperties.ExecType.CP || et == LopProperties.ExecType.SPARK || et == LopProperties.ExecType.GPU) {
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        } else if (et == LopProperties.ExecType.MR) {
            this.lps.addCompatibility(JobType.GMR);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Reduce, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "Operation = t(" + this._type.name().toLowerCase() + ")";
    }

    public String getOpString() {
        switch (this._type) {
            case PLUS_MULT: {
                return "+*";
            }
            case MINUS_MULT: {
                return "-*";
            }
            case IFELSE: {
                return "ifelse";
            }
        }
        return null;
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpString());
        String[] inputs = new String[]{input1, input2, input3};
        for (int i = 0; i < 3; ++i) {
            sb.append("\u00b0");
            if (this.getExecType() == LopProperties.ExecType.MR && this.getInputs().get(i).getDataType().isScalar()) {
                sb.append(this.getInputs().get(i).prepScalarLabel());
                continue;
            }
            sb.append(this.getInputs().get(i).prepInputOperand(inputs[i]));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String getInstructions(int input1, int input2, int input3, int output) {
        return this.getInstructions(String.valueOf(input1), String.valueOf(input2), String.valueOf(input3), String.valueOf(output));
    }

    public static enum OperationType {
        PLUS_MULT,
        MINUS_MULT,
        IFELSE;

    }
}

