/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipArchiveInputStream
extends ArchiveInputStream {
    private final ZipEncoding zipEncoding;
    private final boolean useUnicodeExtraFields;
    private final InputStream in;
    private final Inflater inf = new Inflater(true);
    private final CRC32 crc = new CRC32();
    private final Buffer buf = new Buffer(null);
    private CurrentEntry current = null;
    private boolean closed = false;
    private boolean hitCentralDirectory = false;
    private ByteArrayInputStream lastStoredEntry = null;
    private boolean allowStoredEntriesWithDataDescriptor = false;
    private static final int LFH_LEN = 30;
    private static final long TWO_EXP_32 = 0x100000000L;
    private static final byte[] LFH = ZipLong.LFH_SIG.getBytes();
    private static final byte[] CFH = ZipLong.CFH_SIG.getBytes();
    private static final byte[] DD = ZipLong.DD_SIG.getBytes();

    public ZipArchiveInputStream(InputStream inputStream) {
        this(inputStream, "UTF8", true);
    }

    public ZipArchiveInputStream(InputStream inputStream, String encoding, boolean useUnicodeExtraFields) {
        this(inputStream, encoding, useUnicodeExtraFields, false);
    }

    public ZipArchiveInputStream(InputStream inputStream, String encoding, boolean useUnicodeExtraFields, boolean allowStoredEntriesWithDataDescriptor) {
        this.zipEncoding = ZipEncodingHelper.getZipEncoding((String)encoding);
        this.useUnicodeExtraFields = useUnicodeExtraFields;
        this.in = new PushbackInputStream(inputStream, Buffer.access$100((Buffer)this.buf).length);
        this.allowStoredEntriesWithDataDescriptor = allowStoredEntriesWithDataDescriptor;
    }

    public ZipArchiveEntry getNextZipEntry() throws IOException {
        if (this.closed || this.hitCentralDirectory) {
            return null;
        }
        if (this.current != null) {
            this.closeEntry();
        }
        byte[] lfh = new byte[30];
        try {
            this.readFully(lfh);
        }
        catch (EOFException e) {
            return null;
        }
        ZipLong sig = new ZipLong(lfh);
        if (sig.equals(ZipLong.CFH_SIG)) {
            this.hitCentralDirectory = true;
            return null;
        }
        if (!sig.equals(ZipLong.LFH_SIG)) {
            return null;
        }
        int off = 4;
        this.current = new CurrentEntry(null);
        int versionMadeBy = ZipShort.getValue((byte[])lfh, (int)off);
        CurrentEntry.access$300((CurrentEntry)this.current).setPlatform(versionMadeBy >> 8 & 0xF);
        GeneralPurposeBit gpFlag = GeneralPurposeBit.parse((byte[])lfh, (int)(off += 2));
        boolean hasUTF8Flag = gpFlag.usesUTF8ForNames();
        ZipEncoding entryEncoding = hasUTF8Flag ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        CurrentEntry.access$402((CurrentEntry)this.current, (boolean)gpFlag.usesDataDescriptor());
        CurrentEntry.access$300((CurrentEntry)this.current).setGeneralPurposeBit(gpFlag);
        CurrentEntry.access$300((CurrentEntry)this.current).setMethod(ZipShort.getValue((byte[])lfh, (int)(off += 2)));
        long time = ZipUtil.dosToJavaTime((long)ZipLong.getValue(lfh, off += 2));
        CurrentEntry.access$300((CurrentEntry)this.current).setTime(time);
        off += 4;
        ZipLong size = null;
        ZipLong cSize = null;
        if (!CurrentEntry.access$400((CurrentEntry)this.current)) {
            CurrentEntry.access$300((CurrentEntry)this.current).setCrc(ZipLong.getValue(lfh, off));
            cSize = new ZipLong(lfh, off += 4);
            size = new ZipLong(lfh, off += 4);
            off += 4;
        } else {
            off += 12;
        }
        int fileNameLen = ZipShort.getValue((byte[])lfh, (int)off);
        int extraLen = ZipShort.getValue((byte[])lfh, (int)(off += 2));
        off += 2;
        byte[] fileName = new byte[fileNameLen];
        this.readFully(fileName);
        CurrentEntry.access$300((CurrentEntry)this.current).setName(entryEncoding.decode(fileName), fileName);
        byte[] extraData = new byte[extraLen];
        this.readFully(extraData);
        CurrentEntry.access$300((CurrentEntry)this.current).setExtra(extraData);
        if (!hasUTF8Flag && this.useUnicodeExtraFields) {
            ZipUtil.setNameAndCommentFromExtraFields((ZipArchiveEntry)CurrentEntry.access$300((CurrentEntry)this.current), (byte[])fileName, null);
        }
        this.processZip64Extra(size, cSize);
        return CurrentEntry.access$300((CurrentEntry)this.current);
    }

    private void processZip64Extra(ZipLong size, ZipLong cSize) {
        Zip64ExtendedInformationExtraField z64 = (Zip64ExtendedInformationExtraField)CurrentEntry.access$300((CurrentEntry)this.current).getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        CurrentEntry.access$502((CurrentEntry)this.current, (z64 != null ? 1 : 0) != 0);
        if (!CurrentEntry.access$400((CurrentEntry)this.current)) {
            if (CurrentEntry.access$500((CurrentEntry)this.current) && (cSize.equals(ZipLong.ZIP64_MAGIC) || size.equals(ZipLong.ZIP64_MAGIC))) {
                CurrentEntry.access$300((CurrentEntry)this.current).setCompressedSize(z64.getCompressedSize().getLongValue());
                CurrentEntry.access$300((CurrentEntry)this.current).setSize(z64.getSize().getLongValue());
            } else {
                CurrentEntry.access$300((CurrentEntry)this.current).setCompressedSize(cSize.getValue());
                CurrentEntry.access$300((CurrentEntry)this.current).setSize(size.getValue());
            }
        }
    }

    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextZipEntry();
    }

    public boolean canReadEntryData(ArchiveEntry ae) {
        if (ae instanceof ZipArchiveEntry) {
            ZipArchiveEntry ze = (ZipArchiveEntry)ae;
            return ZipUtil.canHandleEntryData((ZipArchiveEntry)ze) && this.supportsDataDescriptorFor(ze);
        }
        return false;
    }

    public int read(byte[] buffer, int start, int length) throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.inf.finished() || this.current == null) {
            return -1;
        }
        if (start <= buffer.length && length >= 0 && start >= 0 && buffer.length - start >= length) {
            ZipUtil.checkRequestedFeatures((ZipArchiveEntry)CurrentEntry.access$300((CurrentEntry)this.current));
            if (!this.supportsDataDescriptorFor(CurrentEntry.access$300((CurrentEntry)this.current))) {
                throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.DATA_DESCRIPTOR, CurrentEntry.access$300((CurrentEntry)this.current));
            }
            if (CurrentEntry.access$300((CurrentEntry)this.current).getMethod() == 0) {
                return this.readStored(buffer, start, length);
            }
            return this.readDeflated(buffer, start, length);
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    private int readStored(byte[] buffer, int start, int length) throws IOException {
        int toRead;
        if (CurrentEntry.access$400((CurrentEntry)this.current)) {
            if (this.lastStoredEntry == null) {
                this.readStoredEntry();
            }
            return this.lastStoredEntry.read(buffer, start, length);
        }
        long csize = CurrentEntry.access$300((CurrentEntry)this.current).getSize();
        if (CurrentEntry.access$600((CurrentEntry)this.current) >= csize) {
            return -1;
        }
        if (Buffer.access$700((Buffer)this.buf) >= Buffer.access$800((Buffer)this.buf)) {
            Buffer.access$702((Buffer)this.buf, (int)0);
            if (Buffer.access$802((Buffer)this.buf, (int)this.in.read(Buffer.access$100((Buffer)this.buf))) == -1) {
                return -1;
            }
            this.count(Buffer.access$800((Buffer)this.buf));
            CurrentEntry.access$914((CurrentEntry)this.current, (long)Buffer.access$800((Buffer)this.buf));
        }
        int n = toRead = length > Buffer.access$800((Buffer)this.buf) ? Buffer.access$800((Buffer)this.buf) - Buffer.access$700((Buffer)this.buf) : length;
        if (csize - CurrentEntry.access$600((CurrentEntry)this.current) < (long)toRead) {
            toRead = (int)(csize - CurrentEntry.access$600((CurrentEntry)this.current));
        }
        System.arraycopy(Buffer.access$100((Buffer)this.buf), Buffer.access$700((Buffer)this.buf), buffer, start, toRead);
        Buffer.access$712((Buffer)this.buf, (int)toRead);
        CurrentEntry.access$614((CurrentEntry)this.current, (long)toRead);
        this.crc.update(buffer, start, toRead);
        return toRead;
    }

    private int readDeflated(byte[] buffer, int start, int length) throws IOException {
        if (this.inf.needsInput()) {
            this.fill();
            if (Buffer.access$800((Buffer)this.buf) > 0) {
                CurrentEntry.access$914((CurrentEntry)this.current, (long)Buffer.access$800((Buffer)this.buf));
            }
        }
        int read = 0;
        try {
            read = this.inf.inflate(buffer, start, length);
        }
        catch (DataFormatException e) {
            throw new ZipException(e.getMessage());
        }
        if (read == 0) {
            if (this.inf.finished()) {
                return -1;
            }
            if (Buffer.access$800((Buffer)this.buf) == -1) {
                throw new IOException("Truncated ZIP file");
            }
        }
        this.crc.update(buffer, start, read);
        return read;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
            this.inf.end();
        }
    }

    public long skip(long value) throws IOException {
        if (value >= 0L) {
            long skipped;
            int x;
            byte[] b = new byte[1024];
            for (skipped = 0L; skipped < value; skipped += (long)x) {
                long rem = value - skipped;
                x = this.read(b, 0, (int)((long)b.length > rem ? rem : (long)b.length));
                if (x != -1) continue;
                return skipped;
            }
            return skipped;
        }
        throw new IllegalArgumentException();
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < ZipArchiveOutputStream.LFH_SIG.length) {
            return false;
        }
        return ZipArchiveInputStream.checksig(signature, ZipArchiveOutputStream.LFH_SIG) || ZipArchiveInputStream.checksig(signature, ZipArchiveOutputStream.EOCD_SIG);
    }

    private static boolean checksig(byte[] signature, byte[] expected) {
        for (int i = 0; i < expected.length; ++i) {
            if (signature[i] == expected[i]) continue;
            return false;
        }
        return true;
    }

    private void closeEntry() throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.current == null) {
            return;
        }
        if (CurrentEntry.access$900((CurrentEntry)this.current) <= CurrentEntry.access$300((CurrentEntry)this.current).getCompressedSize() && !CurrentEntry.access$400((CurrentEntry)this.current)) {
            this.drainCurrentEntryData();
        } else {
            this.skip(Long.MAX_VALUE);
            long inB = CurrentEntry.access$300((CurrentEntry)this.current).getMethod() == 8 ? this.getBytesInflated() : CurrentEntry.access$600((CurrentEntry)this.current);
            int diff = (int)(CurrentEntry.access$900((CurrentEntry)this.current) - inB);
            if (diff > 0) {
                this.pushback(Buffer.access$100((Buffer)this.buf), Buffer.access$800((Buffer)this.buf) - diff, diff);
            }
        }
        if (this.lastStoredEntry == null && CurrentEntry.access$400((CurrentEntry)this.current)) {
            this.readDataDescriptor();
        }
        this.inf.reset();
        Buffer.access$1000((Buffer)this.buf);
        this.crc.reset();
        this.current = null;
        this.lastStoredEntry = null;
    }

    private void drainCurrentEntryData() throws IOException {
        long n;
        for (long remaining = CurrentEntry.access$300((CurrentEntry)this.current).getCompressedSize() - CurrentEntry.access$900((CurrentEntry)this.current); remaining > 0L; remaining -= n) {
            n = this.in.read(Buffer.access$100((Buffer)this.buf), 0, (int)Math.min((long)Buffer.access$100((Buffer)this.buf).length, remaining));
            if (n < 0L) {
                throw new EOFException("Truncated ZIP entry: " + CurrentEntry.access$300((CurrentEntry)this.current).getName());
            }
            this.count(n);
        }
    }

    private long getBytesInflated() {
        long inB = this.inf.getBytesRead();
        if (CurrentEntry.access$900((CurrentEntry)this.current) >= 0x100000000L) {
            while (inB + 0x100000000L <= CurrentEntry.access$900((CurrentEntry)this.current)) {
                inB += 0x100000000L;
            }
        }
        return inB;
    }

    private void fill() throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (Buffer.access$802((Buffer)this.buf, (int)this.in.read(Buffer.access$100((Buffer)this.buf))) > 0) {
            this.count(Buffer.access$800((Buffer)this.buf));
            this.inf.setInput(Buffer.access$100((Buffer)this.buf), 0, Buffer.access$800((Buffer)this.buf));
        }
    }

    private void readFully(byte[] b) throws IOException {
        int x = 0;
        for (int count = 0; count != b.length; count += x) {
            x = this.in.read(b, count, b.length - count);
            if (x == -1) {
                throw new EOFException();
            }
            this.count(x);
        }
    }

    private void readDataDescriptor() throws IOException {
        byte[] b = new byte[4];
        this.readFully(b);
        ZipLong val = new ZipLong(b);
        if (ZipLong.DD_SIG.equals(val)) {
            this.readFully(b);
            val = new ZipLong(b);
        }
        CurrentEntry.access$300((CurrentEntry)this.current).setCrc(val.getValue());
        b = new byte[16];
        this.readFully(b);
        ZipLong potentialSig = new ZipLong(b, 8);
        if (potentialSig.equals(ZipLong.CFH_SIG) || potentialSig.equals(ZipLong.LFH_SIG)) {
            this.pushback(b, 8, 8);
            CurrentEntry.access$300((CurrentEntry)this.current).setCompressedSize(ZipLong.getValue(b));
            CurrentEntry.access$300((CurrentEntry)this.current).setSize(ZipLong.getValue(b, 4));
        } else {
            CurrentEntry.access$300((CurrentEntry)this.current).setCompressedSize(ZipEightByteInteger.getLongValue((byte[])b));
            CurrentEntry.access$300((CurrentEntry)this.current).setSize(ZipEightByteInteger.getLongValue((byte[])b, (int)8));
        }
    }

    private boolean supportsDataDescriptorFor(ZipArchiveEntry entry) {
        return this.allowStoredEntriesWithDataDescriptor || !entry.getGeneralPurposeBit().usesDataDescriptor() || entry.getMethod() == 8;
    }

    private void readStoredEntry() throws IOException {
        int ddLen;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int off = 0;
        boolean done = false;
        int n = ddLen = CurrentEntry.access$500((CurrentEntry)this.current) ? 20 : 12;
        while (!done) {
            int r = this.in.read(Buffer.access$100((Buffer)this.buf), off, 512 - off);
            if (r <= 0) {
                throw new IOException("Truncated ZIP file");
            }
            if (r + off < 4) {
                off += r;
                continue;
            }
            done = this.bufferContainsSignature(bos, off, r, ddLen);
            if (done) continue;
            off = this.cacheBytesRead(bos, off, r, ddLen);
        }
        byte[] b = bos.toByteArray();
        this.lastStoredEntry = new ByteArrayInputStream(b);
    }

    private boolean bufferContainsSignature(ByteArrayOutputStream bos, int offset, int lastRead, int expectedDDLen) throws IOException {
        boolean done = false;
        int readTooMuch = 0;
        for (int i = 0; !done && i < lastRead - 4; ++i) {
            if (Buffer.access$100((Buffer)this.buf)[i] != LFH[0] || Buffer.access$100((Buffer)this.buf)[i + 1] != LFH[1]) continue;
            if (Buffer.access$100((Buffer)this.buf)[i + 2] == LFH[2] && Buffer.access$100((Buffer)this.buf)[i + 3] == LFH[3] || Buffer.access$100((Buffer)this.buf)[i] == CFH[2] && Buffer.access$100((Buffer)this.buf)[i + 3] == CFH[3]) {
                readTooMuch = offset + lastRead - i - expectedDDLen;
                done = true;
            } else if (Buffer.access$100((Buffer)this.buf)[i + 2] == DD[2] && Buffer.access$100((Buffer)this.buf)[i + 3] == DD[3]) {
                readTooMuch = offset + lastRead - i;
                done = true;
            }
            if (!done) continue;
            this.pushback(Buffer.access$100((Buffer)this.buf), offset + lastRead - readTooMuch, readTooMuch);
            bos.write(Buffer.access$100((Buffer)this.buf), 0, i);
            this.readDataDescriptor();
        }
        return done;
    }

    private int cacheBytesRead(ByteArrayOutputStream bos, int offset, int lastRead, int expecteDDLen) {
        int cacheable = offset + lastRead - expecteDDLen - 3;
        if (cacheable > 0) {
            bos.write(Buffer.access$100((Buffer)this.buf), 0, cacheable);
            System.arraycopy(Buffer.access$100((Buffer)this.buf), cacheable, Buffer.access$100((Buffer)this.buf), 0, expecteDDLen + 3);
            offset = expecteDDLen + 3;
        } else {
            offset += lastRead;
        }
        return offset;
    }

    private void pushback(byte[] buf, int offset, int length) throws IOException {
        ((PushbackInputStream)this.in).unread(buf, offset, length);
        this.pushedBackBytes(length);
    }
}

