/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress.estim;

import org.apache.sysml.runtime.compress.CompressedMatrixBlock;

public class CompressedSizeInfo {
    private final int _estCard;
    private final int _estNnz;
    private final long _rleSize;
    private final long _oleSize;
    private final long _ddcSize;

    public CompressedSizeInfo(int estCard, int estNnz, long rleSize, long oleSize, long ddcSize) {
        this._estCard = estCard;
        this._estNnz = estNnz;
        this._rleSize = rleSize;
        this._oleSize = oleSize;
        this._ddcSize = ddcSize;
    }

    public long getRLESize() {
        return this._rleSize;
    }

    public long getOLESize() {
        return this._oleSize;
    }

    public long getDDCSize() {
        return CompressedMatrixBlock.ALLOW_DDC_ENCODING ? this._ddcSize : Long.MAX_VALUE;
    }

    public long getMinSize() {
        return Math.min(Math.min(this.getRLESize(), this.getOLESize()), this.getDDCSize());
    }

    public int getEstCard() {
        return this._estCard;
    }

    public int getEstNnz() {
        return this._estNnz;
    }
}

