/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.debug;

import java.util.TreeMap;
import org.apache.sysml.runtime.instructions.cp.BreakPointInstruction;

public class DMLBreakpointManager {
    private static TreeMap<Integer, BreakPointInstruction> breakpoints = new TreeMap();

    public static TreeMap<Integer, BreakPointInstruction> getBreakpoints() {
        if (breakpoints.size() > 0) {
            return breakpoints;
        }
        return null;
    }

    public static BreakPointInstruction getBreakpoint(int lineNumber) {
        if (!breakpoints.containsKey(lineNumber)) {
            return null;
        }
        return breakpoints.get(lineNumber);
    }

    public static void insertBreakpoint(BreakPointInstruction breakpoint, int lineNumber) {
        if (breakpoints.containsKey(lineNumber)) {
            if (breakpoints.get(lineNumber).getBPInstructionStatus() != BreakPointInstruction.BPINSTRUCTION_STATUS.INVISIBLE) {
                System.out.format("Breakpoint updated at %s, line, %d.\n", breakpoint.getBPInstructionLocation(), lineNumber);
            } else {
                System.out.format("Breakpoint added at %s, line %d.\n", breakpoint.getBPInstructionLocation(), lineNumber);
            }
            breakpoints.put(lineNumber, breakpoint);
        }
    }

    public static void insertBreakpoint(int lineNumber) {
        if (breakpoints.containsKey(lineNumber)) {
            breakpoints.get(lineNumber).setBPInstructionStatus(BreakPointInstruction.BPINSTRUCTION_STATUS.INVISIBLE);
        } else {
            breakpoints.put(lineNumber, new BreakPointInstruction(BreakPointInstruction.BPINSTRUCTION_STATUS.INVISIBLE));
        }
    }

    public static void updateBreakpoint(int lineNumber, BreakPointInstruction.BPINSTRUCTION_STATUS status) {
        if (breakpoints.containsKey(lineNumber)) {
            breakpoints.get(lineNumber).setBPInstructionStatus(status);
            System.out.format("Breakpoint updated at %s, line %d.\n", breakpoints.get(lineNumber).getBPInstructionLocation(), lineNumber);
        }
    }

    public static void removeBreakpoint(int lineNumber, BreakPointInstruction.BPINSTRUCTION_STATUS status) {
        if (breakpoints.containsKey(lineNumber)) {
            breakpoints.get(lineNumber).setBPInstructionStatus(status);
            System.out.format("Breakpoint deleted at %s, line %d.\n", breakpoints.get(lineNumber).getBPInstructionLocation(), lineNumber);
        }
    }
}

