/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource.factory;

import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp.datasources.PerUserPoolDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;
import org.apache.synapse.commons.datasource.DataSourceInformation;

public class DataSourceFactory {
    private static final Log log = LogFactory.getLog(DataSourceFactory.class);

    private DataSourceFactory() {
    }

    public static DataSource createDataSource(DataSourceInformation dataSourceInformation) {
        String url;
        String dsType = dataSourceInformation.getType();
        String driver = dataSourceInformation.getDriver();
        if (driver == null || "".equals(driver)) {
            DataSourceFactory.handleException("Database driver class name cannot be found.");
        }
        if ((url = dataSourceInformation.getUrl()) == null || "".equals(url)) {
            DataSourceFactory.handleException("Database connection URL cannot be found.");
        }
        String user = dataSourceInformation.getSecretInformation().getUser();
        String password = dataSourceInformation.getSecretInformation().getResolvedSecret();
        int defaultTransactionIsolation = dataSourceInformation.getDefaultTransactionIsolation();
        if ("BasicDataSource".equals(dsType)) {
            String validationQuery;
            String defaultCatalog;
            BasicDataSource basicDataSource = new BasicDataSource();
            basicDataSource.setDriverClassName(driver);
            basicDataSource.setUrl(url);
            if (user != null && !"".equals(user)) {
                basicDataSource.setUsername(user);
            }
            if (password != null && !"".equals(password)) {
                basicDataSource.setPassword(password);
            }
            basicDataSource.setMaxActive(dataSourceInformation.getMaxActive());
            basicDataSource.setMaxIdle(dataSourceInformation.getMaxIdle());
            basicDataSource.setMaxWait(dataSourceInformation.getMaxWait());
            basicDataSource.setMinIdle(dataSourceInformation.getMinIdle());
            basicDataSource.setDefaultAutoCommit(dataSourceInformation.isDefaultAutoCommit());
            basicDataSource.setDefaultReadOnly(dataSourceInformation.isDefaultReadOnly());
            basicDataSource.setTestOnBorrow(dataSourceInformation.isTestOnBorrow());
            basicDataSource.setTestOnReturn(dataSourceInformation.isTestOnReturn());
            basicDataSource.setTestWhileIdle(dataSourceInformation.isTestWhileIdle());
            basicDataSource.setMinEvictableIdleTimeMillis(dataSourceInformation.getMinEvictableIdleTimeMillis());
            basicDataSource.setTimeBetweenEvictionRunsMillis(dataSourceInformation.getTimeBetweenEvictionRunsMillis());
            basicDataSource.setNumTestsPerEvictionRun(dataSourceInformation.getNumTestsPerEvictionRun());
            basicDataSource.setMaxOpenPreparedStatements(dataSourceInformation.getMaxOpenPreparedStatements());
            basicDataSource.setAccessToUnderlyingConnectionAllowed(dataSourceInformation.isAccessToUnderlyingConnectionAllowed());
            basicDataSource.setInitialSize(dataSourceInformation.getInitialSize());
            basicDataSource.setPoolPreparedStatements(dataSourceInformation.isPoolPreparedStatements());
            if (defaultTransactionIsolation != -1) {
                basicDataSource.setDefaultTransactionIsolation(defaultTransactionIsolation);
            }
            if ((defaultCatalog = dataSourceInformation.getDefaultCatalog()) != null && !"".equals(defaultCatalog)) {
                basicDataSource.setDefaultCatalog(defaultCatalog);
            }
            if ((validationQuery = dataSourceInformation.getValidationQuery()) != null && !"".equals(validationQuery)) {
                basicDataSource.setValidationQuery(validationQuery);
            }
            return basicDataSource;
        }
        if ("PerUserPoolDataSource".equals(dsType)) {
            String validationQuery;
            DriverAdapterCPDS adapterCPDS = new DriverAdapterCPDS();
            try {
                adapterCPDS.setDriver(driver);
            }
            catch (ClassNotFoundException e) {
                DataSourceFactory.handleException("Error setting driver : " + driver + " in DriverAdapterCPDS", e);
            }
            adapterCPDS.setUrl(url);
            if (user != null && !"".equals(user)) {
                adapterCPDS.setUser(user);
            }
            if (password != null && !"".equals(password)) {
                adapterCPDS.setPassword(password);
            }
            adapterCPDS.setPoolPreparedStatements(dataSourceInformation.isPoolPreparedStatements());
            adapterCPDS.setMaxIdle(dataSourceInformation.getMaxIdle());
            PerUserPoolDataSource perUserPoolDataSource = new PerUserPoolDataSource();
            perUserPoolDataSource.setConnectionPoolDataSource((ConnectionPoolDataSource)adapterCPDS);
            perUserPoolDataSource.setDefaultMaxActive(dataSourceInformation.getMaxActive());
            perUserPoolDataSource.setDefaultMaxIdle(dataSourceInformation.getMaxIdle());
            perUserPoolDataSource.setDefaultMaxWait((int)dataSourceInformation.getMaxWait());
            perUserPoolDataSource.setDefaultAutoCommit(dataSourceInformation.isDefaultAutoCommit());
            perUserPoolDataSource.setDefaultReadOnly(dataSourceInformation.isDefaultReadOnly());
            perUserPoolDataSource.setTestOnBorrow(dataSourceInformation.isTestOnBorrow());
            perUserPoolDataSource.setTestOnReturn(dataSourceInformation.isTestOnReturn());
            perUserPoolDataSource.setTestWhileIdle(dataSourceInformation.isTestWhileIdle());
            perUserPoolDataSource.setMinEvictableIdleTimeMillis((int)dataSourceInformation.getMinEvictableIdleTimeMillis());
            perUserPoolDataSource.setTimeBetweenEvictionRunsMillis((int)dataSourceInformation.getTimeBetweenEvictionRunsMillis());
            perUserPoolDataSource.setNumTestsPerEvictionRun(dataSourceInformation.getNumTestsPerEvictionRun());
            if (defaultTransactionIsolation != -1) {
                perUserPoolDataSource.setDefaultTransactionIsolation(defaultTransactionIsolation);
            }
            if ((validationQuery = dataSourceInformation.getValidationQuery()) != null && !"".equals(validationQuery)) {
                perUserPoolDataSource.setValidationQuery(validationQuery);
            }
            return perUserPoolDataSource;
        }
        DataSourceFactory.handleException("Unsupported DataSource : " + dsType);
        return null;
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseCommonsException(msg);
    }

    private static void handleException(String msg, Throwable throwable) {
        log.error((Object)msg, throwable);
        throw new SynapseCommonsException(msg, throwable);
    }
}

