/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptException;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.AbstractExpressionLanguage;
import net.sf.oval.internal.Log;
import org.jruby.embed.jsr223.JRubyEngine;
import org.jruby.embed.jsr223.JRubyEngineFactory;

public class ExpressionLanguageJRubyImpl
extends AbstractExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageJRubyImpl.class);
    private final JRubyEngine engine = (JRubyEngine)new JRubyEngineFactory().getScriptEngine();

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        LOG.debug("Evaluating JavaScript expression: {1}", expression);
        try {
            Bindings scope = this.engine.createBindings();
            StringBuilder localVars = new StringBuilder();
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                scope.put("$" + entry.getKey(), entry.getValue());
                localVars.append(entry.getKey()).append("=$").append(entry.getKey()).append("\n");
            }
            return this.engine.eval(String.valueOf(localVars.toString()) + expression, scope);
        }
        catch (ScriptException ex) {
            throw new ExpressionEvaluationException("Evaluating JRuby expression failed: " + expression, ex);
        }
    }
}

