/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import com.opensymphony.xwork2.ActionInvocation;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.result.StrutsResultSupport;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class ChartResult
extends StrutsResultSupport {
    private static final Logger LOG = LogManager.getLogger(ChartResult.class);
    private static final long serialVersionUID = -6484761870055986612L;
    private static final String DEFAULT_TYPE = "png";
    private static final String DEFAULT_VALUE = "chart";
    private JFreeChart chart;
    private boolean chartSet;
    String height;
    String width;
    String type = "png";
    String value = "chart";

    public ChartResult() {
    }

    public ChartResult(JFreeChart chart, String height, String width) {
        this.chart = chart;
        this.height = height;
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart chart) {
        this.chartSet = true;
        this.chart = chart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        block10: {
            this.initializeProperties(invocation);
            if (!this.chartSet) {
                this.chart = (JFreeChart)invocation.getStack().findValue(this.value, JFreeChart.class);
            }
            if (this.chart == null) {
                throw new NullPointerException("No JFreeChart object found on the stack with name " + this.value);
            }
            if (this.height == null) {
                throw new NullPointerException("No height parameter was given.");
            }
            if (this.width == null) {
                throw new NullPointerException("No width parameter was given.");
            }
            HttpServletResponse response = ServletActionContext.getResponse();
            ServletOutputStream os = response.getOutputStream();
            try {
                if (DEFAULT_TYPE.equalsIgnoreCase(this.type)) {
                    response.setContentType("image/png");
                    ChartUtilities.writeChartAsPNG((OutputStream)os, (JFreeChart)this.chart, (int)this.getIntValueFromString(this.width), (int)this.getIntValueFromString(this.height));
                    break block10;
                }
                if ("jpg".equalsIgnoreCase(this.type) || "jpeg".equalsIgnoreCase(this.type)) {
                    response.setContentType("image/jpg");
                    ChartUtilities.writeChartAsJPEG((OutputStream)os, (JFreeChart)this.chart, (int)this.getIntValueFromString(this.width), (int)this.getIntValueFromString(this.height));
                    break block10;
                }
                throw new IllegalArgumentException(this.type + " is not a supported render type (only JPG and PNG are).");
            }
            finally {
                if (os != null) {
                    os.flush();
                }
            }
        }
    }

    private void initializeProperties(ActionInvocation invocation) throws Exception {
        if (this.height != null) {
            this.height = this.conditionalParse(this.height, invocation);
        }
        if (this.width != null) {
            this.width = this.conditionalParse(this.width, invocation);
        }
        if (this.type != null) {
            this.type = this.conditionalParse(this.type, invocation);
        }
        if (this.type == null) {
            this.type = DEFAULT_TYPE;
        }
    }

    private Integer getIntValueFromString(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            LOG.error("Specified value for width or height is not of type Integer...", (Throwable)e);
            return null;
        }
    }
}

