/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.guard;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.guard.ParameterNameResolver;
import net.sf.oval.internal.util.ReflectionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterNameResolverAspectJImpl
implements ParameterNameResolver {
    private final WeakHashMap<AccessibleObject, String[]> parameterNamesCache = new WeakHashMap();

    private void determineParamterNames(Class<?> clazz) throws IllegalArgumentException, IllegalAccessException {
        assert (clazz != null);
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (ReflectionUtils.isStatic(field) && field.getType() == JoinPoint.StaticPart.class) {
                String[] parameterNames;
                ConstructorSignature sig;
                field.setAccessible(true);
                JoinPoint.StaticPart staticPart = (JoinPoint.StaticPart)field.get(null);
                if (staticPart == null) break;
                if (staticPart.getSignature() instanceof ConstructorSignature) {
                    sig = (ConstructorSignature)staticPart.getSignature();
                    parameterNames = sig.getParameterNames();
                    Constructor constr = sig.getConstructor();
                    if (parameterNames.length > 0) {
                        this.parameterNamesCache.put(constr, parameterNames);
                    }
                } else if (staticPart.getSignature() instanceof MethodSignature) {
                    sig = (MethodSignature)staticPart.getSignature();
                    parameterNames = sig.getParameterNames();
                    Method method = sig.getMethod();
                    if (parameterNames.length > 0) {
                        this.parameterNamesCache.put(method, parameterNames);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public String[] getParameterNames(Constructor<?> constructor) throws ReflectionException {
        String[] parameterNames = this.parameterNamesCache.get(constructor);
        if (parameterNames == null) {
            try {
                this.determineParamterNames(constructor.getDeclaringClass());
                parameterNames = this.parameterNamesCache.get(constructor);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException("Cannot detemine parameter names for constructor " + constructor, e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException("Cannot detemine parameter names for constructor " + constructor, e);
            }
        }
        if (parameterNames == null) {
            int parameterCount = constructor.getParameterTypes().length;
            parameterNames = new String[parameterCount];
            int i = 0;
            while (i < parameterCount) {
                parameterNames[i] = "parameter" + i;
                ++i;
            }
            this.parameterNamesCache.put(constructor, parameterNames);
        }
        return parameterNames;
    }

    @Override
    public String[] getParameterNames(Method method) throws ReflectionException {
        String[] parameterNames = this.parameterNamesCache.get(method);
        if (parameterNames == null) {
            try {
                this.determineParamterNames(method.getDeclaringClass());
                parameterNames = this.parameterNamesCache.get(method);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionException("Cannot detemine parameter names for method " + method, e);
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException("Cannot detemine parameter names for method " + method, e);
            }
        }
        if (parameterNames == null) {
            int parameterCount = method.getParameterTypes().length;
            parameterNames = new String[parameterCount];
            int i = 0;
            while (i < parameterCount) {
                parameterNames[i] = "parameter" + i;
                ++i;
            }
            this.parameterNamesCache.put(method, parameterNames);
        }
        return parameterNames;
    }
}

