/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.query.NodeStateNodeTypeInfoProvider;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.ast.NodeTypeInfoProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionContext {
    private final NodeState baseState;
    private final Root root;
    private final QueryEngineSettings settings;
    private final QueryIndexProvider indexProvider;
    private final PermissionProvider permissionProvider;

    public ExecutionContext(NodeState baseState, Root root, QueryEngineSettings settings, QueryIndexProvider indexProvider, PermissionProvider permissionProvider) {
        this.baseState = baseState;
        this.root = root;
        this.settings = settings;
        this.indexProvider = indexProvider;
        this.permissionProvider = permissionProvider;
    }

    @NotNull
    public NodeState getBaseState() {
        return this.baseState;
    }

    public NodeTypeInfoProvider getNodeTypeInfoProvider() {
        return new NodeStateNodeTypeInfoProvider(this.baseState);
    }

    @NotNull
    public Root getRoot() {
        return this.root;
    }

    @NotNull
    public QueryIndexProvider getIndexProvider() {
        return this.indexProvider;
    }

    public QueryEngineSettings getSettings() {
        return this.settings;
    }

    @Nullable
    public PermissionProvider getPermissionProvider() {
        return this.permissionProvider;
    }
}

