/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.testservices.events;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.starter.testservices.events.EventsCounter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Servlet.class, EventHandler.class, EventsCounter.class}, property={"service.description:String=Paths Test Servlet", "service.vendor:String=The Apache Software Foundation", "sling.servlet.paths:String=/testing/EventsCounter", "sling.servlet.extensions:String=json", "event.topics:String=org/apache/sling/api/resource/Resource/ADDED", "event.topics:String=org/apache/sling/api/resource/ResourceResolverMapping/CHANGED"})
public class EventsCounterImpl
extends SlingSafeMethodsServlet
implements EventHandler,
EventsCounter {
    private final Map<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public synchronized void handleEvent(Event event) {
        String topic = event.getTopic();
        AtomicInteger counter = this.counters.computeIfAbsent(topic, k -> new AtomicInteger());
        counter.incrementAndGet();
        this.log.debug("{} counter is now {}", (Object)topic, (Object)counter.get());
    }

    @Override
    public synchronized int getEventsCount(String topic) {
        AtomicInteger counter = this.counters.get(topic);
        if (counter == null) {
            this.log.debug("getEventsCount({}) returns 0, counter not found", (Object)topic);
            return 0;
        }
        return counter.get();
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            JSONWriter w = new JSONWriter(response.getWriter());
            w.object();
            for (Map.Entry<String, AtomicInteger> entry : this.counters.entrySet()) {
                w.key(entry.getKey()).value(entry.getValue());
            }
            w.endObject();
            w.flush();
        }
        catch (IOException je) {
            throw (IOException)new IOException("JSONException in doGet").initCause(je);
        }
    }
}

