/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.testservices.servlets;

import java.io.IOException;
import javax.jcr.Repository;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Servlet.class}, property={"service.description:String=Repository Descriptors Servlet", "service.vendor:String=The Apache Software Foundation", "sling.servlet.paths:String=/testing/RepositoryDescriptors", "sling.servlet.extensions:String=json"})
public class RepositoryDescriptorsServlet
extends SlingSafeMethodsServlet {
    @Reference
    private Repository repository;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            JSONWriter w = new JSONWriter(response.getWriter());
            w.object();
            w.key("descriptors");
            w.object();
            for (String key : this.repository.getDescriptorKeys()) {
                w.key(key).value(this.repository.getDescriptor(key));
            }
            w.endObject();
            w.endObject();
            w.flush();
        }
        catch (IOException je) {
            throw (IOException)new IOException("JSONException in doGet").initCause(je);
        }
    }
}

