/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.server.impl.security;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.DefaultAccessManager;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.sling.jcr.jackrabbit.server.impl.AccessManagerFactoryTracker;
import org.apache.sling.jcr.jackrabbit.server.impl.Activator;
import org.apache.sling.jcr.jackrabbit.server.security.accessmanager.AccessManagerPlugin;
import org.apache.sling.jcr.jackrabbit.server.security.accessmanager.AccessManagerPluginFactory;
import org.apache.sling.jcr.jackrabbit.server.security.accessmanager.WorkspaceAccessManagerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluggableDefaultAccessManager
extends DefaultAccessManager {
    private AccessManagerPlugin accessManagerPlugin;
    private NamePathResolver namePathResolver;
    private static final Logger log = LoggerFactory.getLogger(PluggableDefaultAccessManager.class);
    protected AccessManagerPluginFactory accessManagerFactory;
    protected AccessManagerFactoryTracker accessManagerFactoryTracker;
    private Session session;
    private Subject subject;
    private static int pluginWarning = 0;
    private HierarchyManager hierMgr;

    protected AccessManagerPluginFactory getAccessManagerFactory() {
        return this.accessManagerFactoryTracker.getFactory(this);
    }

    @Override
    public void init(AMContext context) throws AccessDeniedException, Exception {
        this.init(context, null, null);
    }

    @Override
    public void init(AMContext context, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessMgr) throws AccessDeniedException, Exception {
        this.accessManagerFactoryTracker = Activator.getAccessManagerFactoryTracker();
        this.accessManagerFactory = this.getAccessManagerFactory();
        if (this.accessManagerFactory != null) {
            this.accessManagerPlugin = this.accessManagerFactory.getAccessManager();
        }
        this.sanityCheck();
        super.init(context, acProvider, wspAccessMgr);
        this.namePathResolver = context.getNamePathResolver();
        if (this.accessManagerPlugin != null) {
            this.accessManagerPlugin.init(context.getSubject(), context.getSession());
        }
        this.session = context.getSession();
        this.subject = context.getSubject();
        this.hierMgr = context.getHierarchyManager();
    }

    @Override
    public void close() throws Exception {
        this.accessManagerFactoryTracker.unregister(this);
        super.close();
        if (this.accessManagerPlugin != null) {
            this.accessManagerPlugin.close();
        }
    }

    public void endSession() {
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
        }
    }

    @Override
    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        this.sanityCheck();
        super.checkPermission(id, permissions);
    }

    @Override
    public boolean isGranted(ItemId id, int permissions) throws ItemNotFoundException, RepositoryException {
        return super.isGranted(id, permissions);
    }

    @Override
    public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
        if (this.sanityCheck()) {
            return this.accessManagerPlugin.isGranted(this.namePathResolver.getJCRPath(absPath), permissions);
        }
        return super.isGranted(absPath, permissions);
    }

    @Override
    public boolean isGranted(Path parentPath, Name childName, int permissions) throws RepositoryException {
        return super.isGranted(parentPath, childName, permissions);
    }

    @Override
    public boolean canRead(Path itemPath, ItemId itemId) throws RepositoryException {
        if (this.sanityCheck()) {
            String resolvedPath = null;
            if (itemPath != null) {
                resolvedPath = this.namePathResolver.getJCRPath(itemPath);
            } else if (itemId != null) {
                Path path = this.hierMgr.getPath(itemId);
                resolvedPath = this.namePathResolver.getJCRPath(path);
            }
            return this.accessManagerPlugin.canRead(resolvedPath);
        }
        return super.canRead(itemPath, itemId);
    }

    @Override
    public boolean canAccess(String workspaceName) throws RepositoryException {
        WorkspaceAccessManagerPlugin plugin = null;
        if (this.sanityCheck()) {
            plugin = this.accessManagerPlugin.getWorkspaceAccessManager();
        }
        if (plugin != null) {
            return plugin.canAccess(workspaceName);
        }
        return super.canAccess(workspaceName);
    }

    private boolean sanityCheck() throws RepositoryException {
        if (this.accessManagerPlugin == null) {
            AccessManagerPluginFactory factory = this.accessManagerFactoryTracker.getFactory(this);
            if (factory == null) {
                if (pluginWarning == 0) {
                    ++pluginWarning;
                    log.warn("No pluggable AccessManager available, falling back to DefaultAccessManager");
                } else {
                    log.debug("No pluggable AccessManager available, falling back to DefaultAccessManager");
                }
                return false;
            }
            this.accessManagerPlugin = factory.getAccessManager();
            try {
                this.accessManagerPlugin.init(this.subject, this.session);
            }
            catch (Exception e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return true;
    }
}

