/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.Map;
import org.apache.felix.cm.json.io.Configurations;
import org.apache.sling.feature.extension.apiregions.api.config.AttributeableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.PropertyDescriptionAddition;

public abstract class ConfigurableEntityAddition
extends AttributeableEntity {
    private final Map<String, PropertyDescriptionAddition> properties = Configurations.newConfiguration();

    public ConfigurableEntityAddition() {
        this.setDefaults();
    }

    public Map<String, PropertyDescriptionAddition> getPropertyDescriptionAdditions() {
        return this.properties;
    }

    @Override
    public void clear() {
        super.clear();
        this.getPropertyDescriptionAdditions().clear();
    }

    @Override
    public void fromJSONObject(JsonObject jsonObj) throws IOException {
        super.fromJSONObject(jsonObj);
        try {
            JsonValue val = this.getAttributes().remove("properties");
            if (val != null) {
                for (Map.Entry innerEntry : val.asJsonObject().entrySet()) {
                    PropertyDescriptionAddition prop = new PropertyDescriptionAddition();
                    prop.fromJSONObject(((JsonValue)innerEntry.getValue()).asJsonObject());
                    if (this.getPropertyDescriptionAdditions().put((String)innerEntry.getKey(), prop) == null) continue;
                    throw new IOException("Duplicate key for property description (keys are case-insensitive) : ".concat((String)innerEntry.getKey()));
                }
            }
        }
        catch (JsonException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected JsonObjectBuilder createJson() throws IOException {
        JsonObjectBuilder objBuilder = super.createJson();
        if (!this.getPropertyDescriptionAdditions().isEmpty()) {
            JsonObjectBuilder propBuilder = Json.createObjectBuilder();
            for (Map.Entry<String, PropertyDescriptionAddition> entry : this.getPropertyDescriptionAdditions().entrySet()) {
                propBuilder.add(entry.getKey(), entry.getValue().createJson());
            }
            objBuilder.add("properties", propBuilder);
        }
        return objBuilder;
    }
}

