/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.io.IOException;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.repoinit.createpath.CreatePathSegmentProcessor;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.apache.sling.repoinit.parser.operations.CreatePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParentFolderRepoInitHandler {
    private static final Logger logger = LoggerFactory.getLogger(ParentFolderRepoInitHandler.class);
    private final Set<RepoPath> parentFolderPaths = new HashSet<RepoPath>();

    ParentFolderRepoInitHandler() {
    }

    void addParentsForPath(@NotNull String contentPackageEntryRepositoryPath) {
        String parentFolder = contentPackageEntryRepositoryPath;
        if (StringUtils.endsWith((CharSequence)contentPackageEntryRepositoryPath, (CharSequence)".content.xml")) {
            parentFolder = StringUtils.substringBeforeLast((String)parentFolder, (String)"/.content.xml");
        }
        parentFolder = StringUtils.substringBeforeLast((String)parentFolder, (String)"/");
        parentFolder = StringUtils.substringAfter((String)parentFolder, (String)"/jcr_root");
        this.parentFolderPaths.add(new RepoPath(parentFolder));
    }

    void reset() {
        this.parentFolderPaths.clear();
    }

    void addRepoinitExtension(@NotNull List<VaultPackageAssembler> assemblers, @NotNull FeaturesManager featureManager) throws IOException, ConverterException {
        try (Formatter formatter = new Formatter();){
            this.parentFolderPaths.stream().filter(entry -> this.parentFolderPaths.stream().noneMatch(other -> !other.equals(entry) && other.startsWith((RepoPath)entry))).filter(entry -> !entry.isRepositoryPath()).map(entry -> this.getCreatePath((RepoPath)entry, (Collection<VaultPackageAssembler>)assemblers)).filter(Objects::nonNull).forEach(createPath -> formatter.format("%s", createPath.asRepoInitString()));
            String text = formatter.toString();
            if (!text.isEmpty()) {
                featureManager.addOrAppendRepoInitExtension("content-package", text, null);
            }
        }
    }

    @Nullable
    CreatePath getCreatePath(@NotNull RepoPath path, @NotNull Collection<VaultPackageAssembler> packageAssemblers) {
        if (path.getParent() == null) {
            logger.debug("Omit create path statement for path '{}'", (Object)path);
            return null;
        }
        CreatePath cp = new CreatePath("sling:Folder");
        CreatePathSegmentProcessor.processSegments(path, packageAssemblers, cp);
        return cp;
    }
}

