/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.filters;

import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.cms.AuthorizableWrapper;
import org.apache.sling.cms.Site;
import org.apache.sling.cms.SiteManager;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, immediate=true, property={"sling.filter.scope=request"})
public class LocaleFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LocaleFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof SlingHttpServletRequest) {
            Locale locale = null;
            SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
            SiteManager mgr = (SiteManager)slingRequest.getResource().adaptTo(SiteManager.class);
            if (mgr != null) {
                Site site = mgr.getSite();
                if (site != null) {
                    log.debug("Setting bundle for {}", (Object)site.getLocaleString());
                    locale = site.getLocale();
                } else {
                    log.trace("No site for {}", (Object)slingRequest);
                }
            } else {
                log.trace("No site manager found for {}", (Object)slingRequest);
            }
            if (locale == null) {
                locale = this.loadUserLocale(slingRequest);
            }
            if (locale == null) {
                locale = request.getLocale();
            }
            this.setLocale(locale, slingRequest);
        }
        chain.doFilter(request, response);
    }

    private Locale loadUserLocale(SlingHttpServletRequest slingRequest) {
        return Optional.ofNullable((AuthorizableWrapper)slingRequest.getResourceResolver().adaptTo(AuthorizableWrapper.class)).map(AuthorizableWrapper::getLocale).orElse(null);
    }

    private void setLocale(Locale locale, SlingHttpServletRequest slingRequest) {
        log.debug("Setting locale to {}", (Object)locale);
        ResourceBundle bundle = slingRequest.getResourceBundle(locale);
        Config.set((ServletRequest)slingRequest, (String)"javax.servlet.jsp.jstl.fmt.localizationContext", (Object)new LocalizationContext(bundle, locale));
    }

    public void destroy() {
    }
}

