/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OidcAuthCredentials
implements Credentials {
    private final ExternalIdentityRef userId;
    private final String idp;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Set<String> groups = new HashSet<String>();

    public OidcAuthCredentials(@NotNull String userId, @NotNull String idp) {
        this.userId = new ExternalIdentityRef(userId, idp);
        this.idp = idp;
    }

    @NotNull
    public String getUserId() {
        return this.userId.getId();
    }

    @NotNull
    public String getIdp() {
        return this.idp;
    }

    @NotNull
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(@NotNull String key, @NotNull String value) {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            this.attributes.put(key, value);
        }
    }

    @Nullable
    public Object getAttribute(@NotNull String key) {
        return this.attributes.get(key);
    }

    public void addGroup(@NotNull String group) {
        this.groups.add(group);
    }

    @NotNull
    public Iterable<String> getGroups() {
        return this.groups;
    }
}

