/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.filter;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;

public class InvalidRequestFilter
extends AccessControlFilter {
    private static final List<String> SEMICOLON = Collections.unmodifiableList(Arrays.asList(";", "%3b", "%3B"));
    private static final List<String> BACKSLASH = Collections.unmodifiableList(Arrays.asList("\\", "%5c", "%5C"));
    private static final List<String> FORWARDSLASH = Collections.unmodifiableList(Arrays.asList("%2f", "%2F"));
    private static final List<String> PERIOD = Collections.unmodifiableList(Arrays.asList("%2e", "%2E"));
    private boolean blockSemicolon = true;
    private boolean blockBackslash = !Boolean.getBoolean("org.apache.shiro.web.ALLOW_BACKSLASH");
    private boolean blockNonAscii = true;
    private boolean blockTraversal = true;
    private boolean blockEncodedPeriod = true;
    private boolean blockEncodedForwardSlash = true;
    private boolean blockRewriteTraversal = true;

    @Override
    protected boolean isAccessAllowed(ServletRequest req, ServletResponse response, Object mappedValue) throws Exception {
        HttpServletRequest request = WebUtils.toHttp(req);
        return this.isValid(request.getRequestURI()) && this.isValid(request.getServletPath()) && this.isValid(request.getPathInfo());
    }

    private boolean isValid(String uri) {
        return !StringUtils.hasText((String)uri) || !this.containsSemicolon(uri) && !this.containsBackslash(uri) && !this.containsNonAsciiCharacters(uri) && !this.containsTraversal(uri) && !this.containsEncodedPeriods(uri) && !this.containsEncodedForwardSlash(uri);
    }

    @Override
    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        WebUtils.toHttp(response).sendError(400, "Invalid request");
        return false;
    }

    private boolean containsSemicolon(String uri) {
        if (this.isBlockSemicolon()) {
            return SEMICOLON.stream().anyMatch(uri::contains);
        }
        return false;
    }

    private boolean containsBackslash(String uri) {
        if (this.isBlockBackslash()) {
            return BACKSLASH.stream().anyMatch(uri::contains);
        }
        return false;
    }

    private boolean containsNonAsciiCharacters(String uri) {
        if (this.isBlockNonAscii()) {
            return !InvalidRequestFilter.containsOnlyPrintableAsciiCharacters(uri);
        }
        return false;
    }

    private static boolean containsOnlyPrintableAsciiCharacters(String uri) {
        int length = uri.length();
        for (int i = 0; i < length; ++i) {
            char c = uri.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean containsTraversal(String uri) {
        if (!this.isBlockTraversal()) return false;
        if (!this.isNormalized(uri)) return true;
        if (!this.isBlockRewriteTraversal()) return false;
        if (!Stream.of("/..;", "/.;").anyMatch(uri::contains)) return false;
        return true;
    }

    private boolean containsEncodedPeriods(String uri) {
        if (this.isBlockEncodedPeriod()) {
            return PERIOD.stream().anyMatch(uri::contains);
        }
        return false;
    }

    private boolean containsEncodedForwardSlash(String uri) {
        if (this.isBlockEncodedForwardSlash()) {
            return FORWARDSLASH.stream().anyMatch(uri::contains);
        }
        return false;
    }

    private boolean isNormalized(String path) {
        if (path == null) {
            return true;
        }
        int i = path.length();
        while (i > 0) {
            int slashIndex = path.lastIndexOf(47, i - 1);
            int gap = i - slashIndex;
            if (gap == 2 && path.charAt(slashIndex + 1) == '.') {
                return false;
            }
            if (gap == 3 && path.charAt(slashIndex + 1) == '.' && path.charAt(slashIndex + 2) == '.') {
                return false;
            }
            i = slashIndex;
        }
        return true;
    }

    public boolean isBlockSemicolon() {
        return this.blockSemicolon;
    }

    public void setBlockSemicolon(boolean blockSemicolon) {
        this.blockSemicolon = blockSemicolon;
    }

    public boolean isBlockBackslash() {
        return this.blockBackslash;
    }

    public void setBlockBackslash(boolean blockBackslash) {
        this.blockBackslash = blockBackslash;
    }

    public boolean isBlockNonAscii() {
        return this.blockNonAscii;
    }

    public void setBlockNonAscii(boolean blockNonAscii) {
        this.blockNonAscii = blockNonAscii;
    }

    public boolean isBlockTraversal() {
        return this.blockTraversal;
    }

    public void setBlockTraversal(boolean blockTraversal) {
        this.blockTraversal = blockTraversal;
    }

    public boolean isBlockEncodedPeriod() {
        return this.blockEncodedPeriod;
    }

    public void setBlockEncodedPeriod(boolean blockEncodedPeriod) {
        this.blockEncodedPeriod = blockEncodedPeriod;
    }

    public boolean isBlockEncodedForwardSlash() {
        return this.blockEncodedForwardSlash;
    }

    public void setBlockEncodedForwardSlash(boolean blockEncodedForwardSlash) {
        this.blockEncodedForwardSlash = blockEncodedForwardSlash;
    }

    public boolean isBlockRewriteTraversal() {
        return this.blockRewriteTraversal;
    }

    public void setBlockRewriteTraversal(boolean blockRewriteTraversal) {
        this.blockRewriteTraversal = blockRewriteTraversal;
    }
}

