/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.codegen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.servicecomb.toolkit.codegen.ServiceType;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.Generator;

public class MultiContractGenerator
extends DefaultGenerator {
    private List<ClientOptInput> optsList = new ArrayList<ClientOptInput>();

    public Generator addOpts(ClientOptInput opts) {
        this.optsList.add(opts);
        return this;
    }

    public void generateParentProject(List<File> files, List<Map<String, Object>> modules) {
        this.config = this.optsList.get(0).getConfig();
        String outputFilename = this.opts.getConfig().outputFolder() + File.separator + "pom.xml";
        if (!this.config.shouldOverwrite(outputFilename)) {
            this.LOGGER.info("Skipped overwriting " + outputFilename);
        }
        Map templateData = this.config.additionalProperties();
        templateData.put("modules", modules);
        try {
            files.add(this.processTemplateToFile(templateData, "project/pom.mustache", outputFilename));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate parent project pom.xml", e);
        }
    }

    public List<File> generate() {
        if (this.optsList == null || this.optsList.size() == 0) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<Map<String, Object>> modules = new ArrayList<Map<String, Object>>();
        HashSet moduleSet = new HashSet();
        for (ClientOptInput opts : this.optsList) {
            moduleSet.add(opts.getConfig().additionalProperties().get("providerProjectName"));
            moduleSet.add(opts.getConfig().additionalProperties().get("consumerProjectName"));
            moduleSet.add(opts.getConfig().additionalProperties().get("modelProjectName"));
            this.opts(opts);
            fileList.addAll(super.generate());
        }
        moduleSet.forEach(module -> modules.add(Collections.singletonMap("module", module)));
        if (ServiceType.ALL.getValue().equals(Optional.ofNullable(this.opts.getConfig().additionalProperties().get("serviceType")).orElse(ServiceType.ALL.getValue()))) {
            this.generateParentProject(fileList, modules);
        }
        return fileList;
    }
}

