/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.utils;

public class SemVer
implements Comparable<SemVer> {
    public final int major;
    public final int minor;
    public final int revision;

    public SemVer(String versionString) {
        String[] tokens = versionString.split("\\.");
        this.major = Integer.parseInt(tokens[0]);
        this.minor = tokens.length < 2 ? 0 : Integer.parseInt(tokens[1]);
        this.revision = tokens.length < 3 ? 0 : Integer.parseInt(tokens[2]);
    }

    @Override
    public int compareTo(SemVer o) {
        int cmp = this.major - o.major;
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.minor - o.minor;
        if (cmp != 0) {
            return cmp;
        }
        return this.revision - o.revision;
    }

    public boolean atLeast(String other) {
        return this.compareTo(new SemVer(other)) >= 0;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.revision;
    }
}

