/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.context;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.generator.context.IExtensionsContext;
import org.apache.servicecomb.toolkit.generator.context.ISchemaContext;
import org.apache.servicecomb.toolkit.generator.context.OperationContext;
import org.apache.servicecomb.toolkit.generator.parser.api.OpenApiAnnotationParser;

public class OasContext
implements IExtensionsContext {
    private OpenAPI openAPI;
    private String basePath;
    private Class<?> cls;
    private List<OperationContext> operationList = new ArrayList<OperationContext>();
    private OpenApiAnnotationParser parser;
    private List<ISchemaContext> schemaCtxList = new ArrayList<ISchemaContext>();
    private String httpMethod;
    private String[] consumes;
    private String[] produces;
    private String[] headers;

    public OasContext(OpenApiAnnotationParser parser) {
        this(new OpenAPI(), parser);
    }

    public OasContext(OpenAPI openAPI, OpenApiAnnotationParser parser) {
        this.openAPI = openAPI;
        this.parser = parser;
    }

    public OpenAPI toOpenAPI() {
        this.ensurePaths();
        for (OperationContext operationCtx : this.operationList) {
            PathItem pathItem;
            if (!operationCtx.hasOperation()) continue;
            if (this.openAPI.getPaths() == null) {
                this.openAPI.setPaths(new Paths());
            }
            if ((pathItem = (PathItem)this.openAPI.getPaths().get((Object)operationCtx.getPath())) == null) {
                pathItem = new PathItem();
                this.openAPI.path(operationCtx.getPath(), pathItem);
            }
            pathItem.operation(PathItem.HttpMethod.valueOf((String)operationCtx.getHttpMethod()), operationCtx.toOperation());
        }
        if (this.openAPI.getPaths() == null || this.openAPI.getPaths().size() == 0) {
            return null;
        }
        this.openAPI.info(new Info().title("gen").version("1.0.0"));
        this.correctBasepath();
        this.correctComponents();
        this.openAPI.servers(Collections.singletonList(new Server().url(this.basePath)));
        this.schemaCtxList.forEach(schemaCtx -> this.openAPI.schema(schemaCtx.getSchema().getName(), schemaCtx.getSchema()));
        return this.openAPI;
    }

    private void correctComponents() {
        Components nullComponents = new Components();
        if (nullComponents.equals((Object)this.getComponents())) {
            this.openAPI.setComponents(null);
        }
    }

    private void correctBasepath() {
        if (StringUtils.isEmpty((CharSequence)this.basePath)) {
            this.basePath = "/";
        }
        if (!this.basePath.startsWith("/")) {
            this.basePath = "/" + this.basePath;
        }
    }

    public Components getComponents() {
        if (this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(new Components());
        }
        return this.openAPI.getComponents();
    }

    private void ensurePaths() {
        if (this.openAPI.getPaths() == null) {
            this.openAPI.setPaths(new Paths());
        }
    }

    @Override
    public OpenApiAnnotationParser getParser() {
        return this.parser;
    }

    public void setParser(OpenApiAnnotationParser parser) {
        this.parser = parser;
    }

    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public void setCls(Class<?> cls) {
        this.cls = cls;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void addOperation(OperationContext operation) {
        this.operationList.add(operation);
    }

    @Override
    public void addExtension(String name, Object value) {
        this.openAPI.addExtension(name, value);
    }

    @Override
    public Map<String, Object> getExtensions() {
        return this.openAPI.getExtensions();
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String[] getConsumers() {
        return this.consumes;
    }

    public void setConsumers(String[] consumes) {
        this.consumes = consumes;
    }

    public String[] getProduces() {
        return this.produces;
    }

    public void setProduces(String[] produces) {
        this.produces = produces;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(String[] headers) {
        this.headers = headers;
    }
}

