/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.metrics;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsPublisher;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.jet.impl.JobExecutionService;
import com.hazelcast.jet.impl.JobMetricsUtil;
import com.hazelcast.jet.impl.metrics.RawJobMetrics;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;

public class JobMetricsPublisher
implements MetricsPublisher {
    private final JobExecutionService jobExecutionService;
    private final UnaryOperator<MetricDescriptor> namePrefixFn;
    private final Map<Long, MetricsCompressor> executionIdToCompressor = new HashMap<Long, MetricsCompressor>();

    public JobMetricsPublisher(@Nonnull JobExecutionService jobExecutionService, @Nonnull Member member) {
        Objects.requireNonNull(jobExecutionService, "jobExecutionService");
        Objects.requireNonNull(member, "member");
        this.jobExecutionService = jobExecutionService;
        this.namePrefixFn = JobMetricsUtil.addMemberPrefixFn(member);
    }

    @Override
    public void publishLong(MetricDescriptor descriptor, long value) {
        MetricsCompressor metricsCompressor = this.getCompressor(descriptor);
        if (metricsCompressor != null) {
            metricsCompressor.addLong((MetricDescriptor)this.namePrefixFn.apply(descriptor), value);
        }
    }

    @Override
    public void publishDouble(MetricDescriptor descriptor, double value) {
        MetricsCompressor metricsCompressor = this.getCompressor(descriptor);
        if (metricsCompressor != null) {
            metricsCompressor.addDouble((MetricDescriptor)this.namePrefixFn.apply(descriptor), value);
        }
    }

    @Override
    public void whenComplete() {
        Set<Map.Entry<Long, MetricsCompressor>> compressorEntries = this.executionIdToCompressor.entrySet();
        Iterator<Map.Entry<Long, MetricsCompressor>> it = compressorEntries.iterator();
        while (it.hasNext()) {
            Map.Entry<Long, MetricsCompressor> entry = it.next();
            MetricsCompressor compressor = entry.getValue();
            if (compressor.count() == 0) {
                it.remove();
            }
            Long executionId = entry.getKey();
            byte[] blob = compressor.getBlobAndReset();
            this.jobExecutionService.updateMetrics(executionId, RawJobMetrics.of(blob));
        }
    }

    @Override
    public String name() {
        return "Job Metrics Publisher";
    }

    private MetricsCompressor getCompressor(MetricDescriptor descriptor) {
        Long executionId = JobMetricsUtil.getExecutionIdFromMetricsDescriptor(descriptor);
        return executionId == null ? null : this.executionIdToCompressor.computeIfAbsent(executionId, id -> new MetricsCompressor());
    }
}

