/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.transfrom.impl;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.app.domain.request.job.TableSchemaReq;
import org.apache.seatunnel.app.domain.request.job.transform.Split;
import org.apache.seatunnel.app.domain.request.job.transform.SplitTransformOptions;
import org.apache.seatunnel.app.domain.request.job.transform.Transform;
import org.apache.seatunnel.app.domain.request.job.transform.TransformOptions;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.transfrom.TransformConfigSwitcher;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;

@AutoService(value={TransformConfigSwitcher.class})
public class SplitTransformSwitcher
implements TransformConfigSwitcher {
    @Override
    public Transform getTransform() {
        return Transform.MULTIFIELDSPLIT;
    }

    @Override
    public FormStructure getFormStructure(OptionRule transformOptionRule) {
        return null;
    }

    @Override
    public Config mergeTransformConfig(Config transformConfig, TransformOptions transformOption, TableSchemaReq inputSchema) {
        SplitTransformOptions splitTransformOptions = (SplitTransformOptions)transformOption;
        Preconditions.checkArgument((splitTransformOptions.getSplits().size() > 0 ? 1 : 0) != 0, (Object)"SplitTransformSwitcher splits must be greater than 0");
        ArrayList splitOPs = new ArrayList();
        for (Split split : splitTransformOptions.getSplits()) {
            HashMap<String, String> splitOP = new HashMap<String, String>();
            splitOP.put("separator", split.getSeparator());
            splitOP.put("split_field", split.getSourceFieldName());
            splitOP.put("output_fields", (String)ConfigValueFactory.fromIterable(split.getOutputFields()));
            splitOPs.add(splitOP);
        }
        return transformConfig.withValue("splitOPs", (ConfigValue)ConfigValueFactory.fromIterable(splitOPs));
    }
}

