/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import com.alibaba.fastjson.JSON;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullStatus;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.PopAckConstants;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.AppendMessageStatus;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.pop.AckMsg;
import org.apache.rocketmq.store.pop.PopCheckPoint;

public class PopReviveService
extends ServiceThread {
    private static final InternalLogger POP_LOGGER = InternalLoggerFactory.getLogger((String)"RocketmqPop");
    private int queueId;
    private BrokerController brokerController;
    private String reviveTopic;
    private volatile boolean shouldRunPopRevive = false;

    public PopReviveService(BrokerController brokerController, String reviveTopic, int queueId) {
        this.queueId = queueId;
        this.brokerController = brokerController;
        this.reviveTopic = reviveTopic;
    }

    public String getServiceName() {
        if (this.brokerController != null && this.brokerController.getBrokerConfig().isInBrokerContainer()) {
            return this.brokerController.getBrokerIdentity().getLoggerIdentifier() + "PopReviveService_" + this.queueId;
        }
        return "PopReviveService_" + this.queueId;
    }

    public void setShouldRunPopRevive(boolean shouldRunPopRevive) {
        this.shouldRunPopRevive = shouldRunPopRevive;
    }

    public boolean isShouldRunPopRevive() {
        return this.shouldRunPopRevive;
    }

    private void reviveRetry(PopCheckPoint popCheckPoint, MessageExt messageExt) throws Exception {
        if (!this.shouldRunPopRevive) {
            POP_LOGGER.info("slave skip retry , revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
            return;
        }
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        if (!popCheckPoint.getTopic().startsWith("%RETRY%")) {
            msgInner.setTopic(KeyBuilder.buildPopRetryTopic((String)popCheckPoint.getTopic(), (String)popCheckPoint.getCId()));
        } else {
            msgInner.setTopic(popCheckPoint.getTopic());
        }
        msgInner.setBody(messageExt.getBody());
        msgInner.setQueueId(0);
        if (messageExt.getTags() != null) {
            msgInner.setTags(messageExt.getTags());
        } else {
            MessageAccessor.setProperties((Message)msgInner, new HashMap());
        }
        msgInner.setBornTimestamp(messageExt.getBornTimestamp());
        msgInner.setBornHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setStoreHost((SocketAddress)this.brokerController.getStoreHost());
        msgInner.setReconsumeTimes(messageExt.getReconsumeTimes() + 1);
        msgInner.getProperties().putAll(messageExt.getProperties());
        if (messageExt.getReconsumeTimes() == 0 || msgInner.getProperties().get("1ST_POP_TIME") == null) {
            msgInner.getProperties().put("1ST_POP_TIME", String.valueOf(popCheckPoint.getPopTime()));
        }
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        this.addRetryTopicIfNoExit(msgInner.getTopic(), popCheckPoint.getCId());
        PutMessageResult putMessageResult = this.brokerController.getEscapeBridge().putMessageToSpecificQueue(msgInner);
        if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
            POP_LOGGER.info("reviveQueueId={},retry msg , ck={}, msg queueId {}, offset {}, reviveDelay={}, result is {} ", new Object[]{this.queueId, popCheckPoint, messageExt.getQueueId(), messageExt.getQueueOffset(), (System.currentTimeMillis() - popCheckPoint.getReviveTime()) / 1000L, putMessageResult});
        }
        if (putMessageResult.getAppendMessageResult() == null || putMessageResult.getAppendMessageResult().getStatus() != AppendMessageStatus.PUT_OK) {
            throw new Exception("reviveQueueId=" + this.queueId + ",revive error ,msg is :" + msgInner);
        }
        this.brokerController.getBrokerStatsManager().incBrokerPutNums(1);
        this.brokerController.getBrokerStatsManager().incTopicPutNums(msgInner.getTopic());
        this.brokerController.getBrokerStatsManager().incTopicPutSize(msgInner.getTopic(), putMessageResult.getAppendMessageResult().getWroteBytes());
        if (this.brokerController.getPopMessageProcessor() != null) {
            this.brokerController.getPopMessageProcessor().notifyMessageArriving(KeyBuilder.parseNormalTopic((String)popCheckPoint.getTopic(), (String)popCheckPoint.getCId()), popCheckPoint.getCId(), -1);
        }
    }

    private void initPopRetryOffset(String topic, String consumerGroup) {
        long offset = this.brokerController.getConsumerOffsetManager().queryOffset(consumerGroup, topic, 0);
        if (offset < 0L) {
            this.brokerController.getConsumerOffsetManager().commitOffset("initPopRetryOffset", consumerGroup, topic, 0, 0L);
        }
    }

    private void addRetryTopicIfNoExit(String topic, String consumerGroup) {
        if (this.brokerController != null) {
            TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(topic);
            if (topicConfig != null) {
                return;
            }
            topicConfig = new TopicConfig(topic);
            topicConfig.setReadQueueNums(PopAckConstants.retryQueueNum);
            topicConfig.setWriteQueueNums(PopAckConstants.retryQueueNum);
            topicConfig.setTopicFilterType(TopicFilterType.SINGLE_TAG);
            topicConfig.setPerm(6);
            topicConfig.setTopicSysFlag(0);
            this.brokerController.getTopicConfigManager().updateTopicConfig(topicConfig);
            this.initPopRetryOffset(topic, consumerGroup);
        }
    }

    protected List<MessageExt> getReviveMessage(long offset, int queueId) {
        PullResult pullResult = this.getMessage("CID_RMQ_SYS_REVIVE_GROUP", this.reviveTopic, queueId, offset, 32);
        if (pullResult == null) {
            return null;
        }
        if (this.reachTail(pullResult, offset)) {
            POP_LOGGER.info("reviveQueueId={}, reach tail,offset {}", (Object)queueId, (Object)offset);
        } else if (pullResult.getPullStatus() == PullStatus.OFFSET_ILLEGAL || pullResult.getPullStatus() == PullStatus.NO_MATCHED_MSG) {
            POP_LOGGER.error("reviveQueueId={}, OFFSET_ILLEGAL {}, result is {}", new Object[]{queueId, offset, pullResult});
            if (!this.shouldRunPopRevive) {
                POP_LOGGER.info("slave skip offset correct topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)queueId);
                return null;
            }
            this.brokerController.getConsumerOffsetManager().commitOffset("127.0.0.1", "CID_RMQ_SYS_REVIVE_GROUP", this.reviveTopic, queueId, pullResult.getNextBeginOffset() - 1L);
        }
        return pullResult.getMsgFoundList();
    }

    private boolean reachTail(PullResult pullResult, long offset) {
        return pullResult.getPullStatus() == PullStatus.NO_NEW_MSG || pullResult.getPullStatus() == PullStatus.OFFSET_ILLEGAL && offset == pullResult.getMaxOffset();
    }

    private MessageExt getBizMessage(String topic, long offset, int queueId, String brokerName) {
        return this.brokerController.getEscapeBridge().getMessage(topic, offset, queueId, brokerName);
    }

    public PullResult getMessage(String group, String topic, int queueId, long offset, int nums) {
        GetMessageResult getMessageResult = this.brokerController.getMessageStore().getMessage(group, topic, queueId, offset, nums, null);
        if (getMessageResult != null) {
            PullStatus pullStatus = PullStatus.NO_NEW_MSG;
            List<MessageExt> foundList = null;
            switch (getMessageResult.getStatus()) {
                case FOUND: {
                    pullStatus = PullStatus.FOUND;
                    foundList = this.decodeMsgList(getMessageResult);
                    this.brokerController.getBrokerStatsManager().incGroupGetNums(group, topic, getMessageResult.getMessageCount());
                    this.brokerController.getBrokerStatsManager().incGroupGetSize(group, topic, getMessageResult.getBufferTotalSize());
                    this.brokerController.getBrokerStatsManager().incBrokerGetNums(getMessageResult.getMessageCount());
                    this.brokerController.getBrokerStatsManager().recordDiskFallBehindTime(group, topic, queueId, this.brokerController.getMessageStore().now() - foundList.get(foundList.size() - 1).getStoreTimestamp());
                    break;
                }
                case NO_MATCHED_MESSAGE: {
                    pullStatus = PullStatus.NO_MATCHED_MSG;
                    POP_LOGGER.debug("no matched message. GetMessageStatus={}, topic={}, groupId={}, requestOffset={}", new Object[]{getMessageResult.getStatus(), topic, group, offset});
                    break;
                }
                case NO_MESSAGE_IN_QUEUE: {
                    POP_LOGGER.debug("no new message. GetMessageStatus={}, topic={}, groupId={}, requestOffset={}", new Object[]{getMessageResult.getStatus(), topic, group, offset});
                    break;
                }
                case MESSAGE_WAS_REMOVING: 
                case NO_MATCHED_LOGIC_QUEUE: 
                case OFFSET_FOUND_NULL: 
                case OFFSET_OVERFLOW_BADLY: 
                case OFFSET_OVERFLOW_ONE: 
                case OFFSET_TOO_SMALL: {
                    pullStatus = PullStatus.OFFSET_ILLEGAL;
                    POP_LOGGER.warn("offset illegal. GetMessageStatus={}, topic={}, groupId={}, requestOffset={}", new Object[]{getMessageResult.getStatus(), topic, group, offset});
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return new PullResult(pullStatus, getMessageResult.getNextBeginOffset(), getMessageResult.getMinOffset(), getMessageResult.getMaxOffset(), foundList);
        }
        long maxQueueOffset = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId);
        if (maxQueueOffset > offset) {
            POP_LOGGER.error("get message from store return null. topic={}, groupId={}, requestOffset={}, maxQueueOffset={}", new Object[]{topic, group, offset, maxQueueOffset});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MessageExt> decodeMsgList(GetMessageResult getMessageResult) {
        ArrayList<MessageExt> foundList = new ArrayList<MessageExt>();
        try {
            List messageBufferList = getMessageResult.getMessageBufferList();
            if (messageBufferList != null) {
                for (int i = 0; i < messageBufferList.size(); ++i) {
                    ByteBuffer bb = (ByteBuffer)messageBufferList.get(i);
                    if (bb == null) {
                        POP_LOGGER.error("bb is null {}", (Object)getMessageResult);
                        continue;
                    }
                    MessageExt msgExt = MessageDecoder.decode((ByteBuffer)bb);
                    if (msgExt == null) {
                        POP_LOGGER.error("decode msgExt is null {}", (Object)getMessageResult);
                        continue;
                    }
                    msgExt.setQueueOffset(((Long)getMessageResult.getMessageQueueOffset().get(i)).longValue());
                    foundList.add(msgExt);
                }
            }
        }
        finally {
            getMessageResult.release();
        }
        return foundList;
    }

    protected void consumeReviveMessage(ConsumeReviveObj consumeReviveObj) {
        long oldOffset;
        HashMap<String, PopCheckPoint> map = consumeReviveObj.map;
        long startScanTime = System.currentTimeMillis();
        long endTime = 0L;
        consumeReviveObj.oldOffset = oldOffset = this.brokerController.getConsumerOffsetManager().queryOffset("CID_RMQ_SYS_REVIVE_GROUP", this.reviveTopic, this.queueId);
        POP_LOGGER.info("reviveQueueId={}, old offset is {} ", (Object)this.queueId, (Object)oldOffset);
        long offset = oldOffset + 1L;
        int noMsgCount = 0;
        long firstRt = 0L;
        while (true) {
            if (!this.shouldRunPopRevive) {
                POP_LOGGER.info("slave skip scan , revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
                break;
            }
            List<MessageExt> messageExts = this.getReviveMessage(offset, this.queueId);
            if (messageExts == null || messageExts.isEmpty()) {
                long old = endTime;
                long timerDelay = this.brokerController.getMessageStore().getTimerMessageStore().getReadBehind();
                long commitLogDelay = this.brokerController.getMessageStore().getTimerMessageStore().getEnqueueBehind();
                if (endTime != 0L && System.currentTimeMillis() - endTime > 3000L && timerDelay <= 0L && commitLogDelay <= 0L) {
                    endTime = System.currentTimeMillis();
                }
                POP_LOGGER.info("reviveQueueId={}, offset is {}, can not get new msg, old endTime {}, new endTime {}", new Object[]{this.queueId, offset, old, endTime});
                if (endTime - firstRt > PopAckConstants.ackTimeInterval + 1000L) break;
                ++noMsgCount;
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if ((long)noMsgCount * 100L <= 4000L) continue;
                break;
            }
            noMsgCount = 0;
            if (System.currentTimeMillis() - startScanTime > this.brokerController.getBrokerConfig().getReviveScanTime()) {
                POP_LOGGER.info("reviveQueueId={}, scan timeout  ", (Object)this.queueId);
                break;
            }
            for (MessageExt messageExt : messageExts) {
                long deliverTime;
                if ("ck".equals(messageExt.getTags())) {
                    PopCheckPoint point;
                    String raw = new String(messageExt.getBody(), DataConverter.charset);
                    if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                        POP_LOGGER.info("reviveQueueId={},find ck, offset:{}, raw : {}", new Object[]{messageExt.getQueueId(), messageExt.getQueueOffset(), raw});
                    }
                    if ((point = (PopCheckPoint)JSON.parseObject((String)raw, PopCheckPoint.class)).getTopic() == null || point.getCId() == null) continue;
                    map.put(point.getTopic() + point.getCId() + point.getQueueId() + point.getStartOffset() + point.getPopTime(), point);
                    point.setReviveOffset(messageExt.getQueueOffset());
                    if (firstRt == 0L) {
                        firstRt = point.getReviveTime();
                    }
                } else if ("ack".equals(messageExt.getTags())) {
                    AckMsg ackMsg;
                    PopCheckPoint point;
                    String raw = new String(messageExt.getBody(), DataConverter.charset);
                    if (this.brokerController.getBrokerConfig().isEnablePopLog()) {
                        POP_LOGGER.info("reviveQueueId={},find ack, offset:{}, raw : {}", new Object[]{messageExt.getQueueId(), messageExt.getQueueOffset(), raw});
                    }
                    if ((point = map.get((ackMsg = (AckMsg)JSON.parseObject((String)raw, AckMsg.class)).getTopic() + ackMsg.getConsumerGroup() + ackMsg.getQueueId() + ackMsg.getStartOffset() + ackMsg.getPopTime())) == null) continue;
                    int indexOfAck = point.indexOfAck(ackMsg.getAckOffset());
                    if (indexOfAck > -1) {
                        point.setBitMap(DataConverter.setBit((int)point.getBitMap(), (int)indexOfAck, (boolean)true));
                    } else {
                        POP_LOGGER.error("invalid ack index, {}, {}", (Object)ackMsg, (Object)point);
                    }
                }
                if ((deliverTime = messageExt.getDeliverTimeMs()) <= endTime) continue;
                endTime = deliverTime;
            }
            offset += (long)messageExts.size();
        }
        consumeReviveObj.endTime = endTime;
    }

    protected void mergeAndRevive(ConsumeReviveObj consumeReviveObj) throws Throwable {
        ArrayList<PopCheckPoint> sortList = consumeReviveObj.genSortList();
        POP_LOGGER.info("reviveQueueId={},ck listSize={}", (Object)this.queueId, (Object)sortList.size());
        if (sortList.size() != 0) {
            POP_LOGGER.info("reviveQueueId={}, 1st ck, startOffset={}, reviveOffset={} ; last ck, startOffset={}, reviveOffset={}", new Object[]{this.queueId, sortList.get(0).getStartOffset(), sortList.get(0).getReviveOffset(), sortList.get(sortList.size() - 1).getStartOffset(), sortList.get(sortList.size() - 1).getReviveOffset()});
        }
        long newOffset = consumeReviveObj.oldOffset;
        for (PopCheckPoint popCheckPoint : sortList) {
            if (!this.shouldRunPopRevive) {
                POP_LOGGER.info("slave skip ck process , revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
                break;
            }
            if (consumeReviveObj.endTime - popCheckPoint.getReviveTime() <= PopAckConstants.ackTimeInterval + 1000L) break;
            String normalTopic = KeyBuilder.parseNormalTopic((String)popCheckPoint.getTopic(), (String)popCheckPoint.getCId());
            if (this.brokerController.getTopicConfigManager().selectTopicConfig(normalTopic) == null) {
                POP_LOGGER.warn("reviveQueueId={},can not get normal topic {} , then continue ", (Object)this.queueId, (Object)popCheckPoint.getTopic());
                newOffset = popCheckPoint.getReviveOffset();
                continue;
            }
            if (null == this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(popCheckPoint.getCId())) {
                POP_LOGGER.warn("reviveQueueId={},can not get cid {} , then continue ", (Object)this.queueId, (Object)popCheckPoint.getCId());
                newOffset = popCheckPoint.getReviveOffset();
                continue;
            }
            this.reviveMsgFromCk(popCheckPoint);
            newOffset = popCheckPoint.getReviveOffset();
        }
        if (newOffset > consumeReviveObj.oldOffset) {
            if (!this.shouldRunPopRevive) {
                POP_LOGGER.info("slave skip commit, revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
                return;
            }
            this.brokerController.getConsumerOffsetManager().commitOffset("127.0.0.1", "CID_RMQ_SYS_REVIVE_GROUP", this.reviveTopic, this.queueId, newOffset);
        }
        consumeReviveObj.newOffset = newOffset;
    }

    private void reviveMsgFromCk(PopCheckPoint popCheckPoint) throws Throwable {
        for (int j = 0; j < popCheckPoint.getNum(); ++j) {
            if (DataConverter.getBit((int)popCheckPoint.getBitMap(), (int)j)) continue;
            long msgOffset = popCheckPoint.ackOffsetByIndex((byte)j);
            MessageExt messageExt = this.getBizMessage(popCheckPoint.getTopic(), msgOffset, popCheckPoint.getQueueId(), popCheckPoint.getBrokerName());
            if (messageExt == null) {
                POP_LOGGER.warn("reviveQueueId={},can not get biz msg topic is {}, offset is {} , then continue ", new Object[]{this.queueId, popCheckPoint.getTopic(), msgOffset});
                continue;
            }
            if (popCheckPoint.getPopTime() < messageExt.getStoreTimestamp()) {
                POP_LOGGER.warn("reviveQueueId={},skip ck from last epoch {}", (Object)this.queueId, (Object)popCheckPoint);
                continue;
            }
            this.reviveRetry(popCheckPoint, messageExt);
        }
    }

    public void run() {
        int slow = 1;
        while (!this.isStopped()) {
            try {
                if (System.currentTimeMillis() < this.brokerController.getShouldStartTime()) {
                    POP_LOGGER.info("PopReviveService Ready to run after {}", (Object)this.brokerController.getShouldStartTime());
                    this.waitForRunning(1000L);
                    continue;
                }
                this.waitForRunning(this.brokerController.getBrokerConfig().getReviveInterval());
                if (!this.shouldRunPopRevive) {
                    POP_LOGGER.info("skip start revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
                    continue;
                }
                POP_LOGGER.info("start revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
                ConsumeReviveObj consumeReviveObj = new ConsumeReviveObj();
                this.consumeReviveMessage(consumeReviveObj);
                if (!this.shouldRunPopRevive) {
                    POP_LOGGER.info("slave skip scan , revive topic={}, reviveQueueId={}", (Object)this.reviveTopic, (Object)this.queueId);
                    continue;
                }
                this.mergeAndRevive(consumeReviveObj);
                ArrayList<PopCheckPoint> sortList = consumeReviveObj.sortList;
                long delay = 0L;
                if (sortList != null && !sortList.isEmpty()) {
                    delay = (System.currentTimeMillis() - sortList.get(0).getReviveTime()) / 1000L;
                    slow = 1;
                }
                POP_LOGGER.info("reviveQueueId={},revive finish,old offset is {}, new offset is {}, ckDelay={}  ", new Object[]{this.queueId, consumeReviveObj.oldOffset, consumeReviveObj.newOffset, delay});
                if (sortList != null && !sortList.isEmpty()) continue;
                POP_LOGGER.info("reviveQueueId={},has no new msg ,take a rest {}", (Object)this.queueId, (Object)slow);
                this.waitForRunning((long)slow * this.brokerController.getBrokerConfig().getReviveInterval());
                if ((long)slow >= this.brokerController.getBrokerConfig().getReviveMaxSlow()) continue;
                ++slow;
            }
            catch (Throwable e) {
                POP_LOGGER.error("reviveQueueId=" + this.queueId + ",revive error", e);
            }
        }
    }

    static class ConsumeReviveObj {
        HashMap<String, PopCheckPoint> map = new HashMap();
        ArrayList<PopCheckPoint> sortList;
        long oldOffset;
        long endTime;
        long newOffset;

        ConsumeReviveObj() {
        }

        ArrayList<PopCheckPoint> genSortList() {
            if (this.sortList != null) {
                return this.sortList;
            }
            this.sortList = new ArrayList<PopCheckPoint>(this.map.values());
            Collections.sort(this.sortList, new Comparator<PopCheckPoint>(){

                @Override
                public int compare(PopCheckPoint o1, PopCheckPoint o2) {
                    return (int)(o1.getReviveOffset() - o2.getReviveOffset());
                }
            });
            return this.sortList;
        }
    }
}

