/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.analysis.function.HarmonicOscillator;
import org.apache.commons.math3.fitting.HarmonicCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.VectorFunction;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class HarmonicFitEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public HarmonicFitEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... objects) throws IOException {
        if (objects.length > 3) {
            throw new IOException("harmonicFit function takes a maximum of 2 arguments.");
        }
        Object first = objects[0];
        double[] x = null;
        double[] y = null;
        if (objects.length == 1) {
            y = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            x = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                x[i] = i;
            }
        } else if (objects.length == 2) {
            Object second = objects[1];
            x = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            y = ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
        }
        HarmonicCurveFitter curveFitter = HarmonicCurveFitter.create();
        WeightedObservedPoints points = new WeightedObservedPoints();
        for (int i = 0; i < x.length; ++i) {
            points.add(x[i], y[i]);
        }
        double[] guess = new HarmonicCurveFitter.ParameterGuesser((Collection)points.toList()).guess();
        curveFitter = curveFitter.withStartPoint(guess);
        double[] coef = curveFitter.fit((Collection)points.toList());
        HarmonicOscillator pf = new HarmonicOscillator(coef[0], coef[1], coef[2]);
        ArrayList<Number> list = new ArrayList<Number>();
        for (double xvalue : x) {
            double yvalue = pf.value(xvalue);
            list.add(yvalue);
        }
        VectorFunction vectorFunction = new VectorFunction((Object)pf, list);
        vectorFunction.addToContext("amplitude", coef[0]);
        vectorFunction.addToContext("angularFrequency", coef[1]);
        vectorFunction.addToContext("phase", coef[2]);
        return vectorFunction;
    }
}

