/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl.writer;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.IntegerWriter;
import org.apache.orc.impl.PositionRecorder;
import org.apache.orc.impl.writer.TreeWriter;
import org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.orc.impl.writer.WriterContext;

public class MapTreeWriter
extends TreeWriterBase {
    private final IntegerWriter lengths;
    private final boolean isDirectV2;
    private final TreeWriter keyWriter;
    private final TreeWriter valueWriter;

    MapTreeWriter(int columnId, TypeDescription schema, WriterContext writer, boolean nullable) throws IOException {
        super(columnId, schema, writer, nullable);
        this.isDirectV2 = this.isNewWriteFormat(writer);
        List<TypeDescription> children = schema.getChildren();
        this.keyWriter = TreeWriter.Factory.create(children.get(0), writer, true);
        this.valueWriter = TreeWriter.Factory.create(children.get(1), writer, true);
        this.lengths = this.createIntegerWriter(writer.createStream(columnId, OrcProto.Stream.Kind.LENGTH), false, this.isDirectV2, writer);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    OrcProto.ColumnEncoding.Builder getEncoding() {
        OrcProto.ColumnEncoding.Builder result = super.getEncoding();
        if (this.isDirectV2) {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2);
        } else {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT);
        }
        return result;
    }

    @Override
    public void createRowIndexEntry() throws IOException {
        super.createRowIndexEntry();
        this.keyWriter.createRowIndexEntry();
        this.valueWriter.createRowIndexEntry();
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        super.writeBatch(vector, offset, length);
        MapColumnVector vec = (MapColumnVector)vector;
        if (vector.isRepeating) {
            if (vector.noNulls || !vector.isNull[0]) {
                int childOffset = (int)vec.offsets[0];
                int childLength = (int)vec.lengths[0];
                for (int i = 0; i < length; ++i) {
                    this.lengths.write(childLength);
                    this.keyWriter.writeBatch(vec.keys, childOffset, childLength);
                    this.valueWriter.writeBatch(vec.values, childOffset, childLength);
                }
                if (this.createBloomFilter) {
                    if (this.bloomFilter != null) {
                        this.bloomFilter.addLong(childLength);
                    }
                    this.bloomFilterUtf8.addLong(childLength);
                }
            }
        } else {
            int currentOffset = 0;
            int currentLength = 0;
            for (int i = 0; i < length; ++i) {
                if (vec.isNull[i + offset]) continue;
                int nextLength = (int)vec.lengths[offset + i];
                int nextOffset = (int)vec.offsets[offset + i];
                this.lengths.write(nextLength);
                if (currentLength == 0) {
                    currentOffset = nextOffset;
                    currentLength = nextLength;
                } else if (currentOffset + currentLength != nextOffset) {
                    this.keyWriter.writeBatch(vec.keys, currentOffset, currentLength);
                    this.valueWriter.writeBatch(vec.values, currentOffset, currentLength);
                    currentOffset = nextOffset;
                    currentLength = nextLength;
                } else {
                    currentLength += nextLength;
                }
                if (!this.createBloomFilter) continue;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addLong(nextLength);
                }
                this.bloomFilterUtf8.addLong(nextLength);
            }
            if (currentLength != 0) {
                this.keyWriter.writeBatch(vec.keys, currentOffset, currentLength);
                this.valueWriter.writeBatch(vec.values, currentOffset, currentLength);
            }
        }
    }

    @Override
    public void writeStripe(OrcProto.StripeFooter.Builder builder, OrcProto.StripeStatistics.Builder stats, int requiredIndexEntries) throws IOException {
        super.writeStripe(builder, stats, requiredIndexEntries);
        this.keyWriter.writeStripe(builder, stats, requiredIndexEntries);
        this.valueWriter.writeStripe(builder, stats, requiredIndexEntries);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    void recordPosition(PositionRecorder recorder) throws IOException {
        super.recordPosition(recorder);
        this.lengths.getPosition(recorder);
    }

    @Override
    public void updateFileStatistics(OrcProto.StripeStatistics stats) {
        super.updateFileStatistics(stats);
        this.keyWriter.updateFileStatistics(stats);
        this.valueWriter.updateFileStatistics(stats);
    }

    @Override
    public long estimateMemory() {
        return super.estimateMemory() + this.lengths.estimateMemory() + this.keyWriter.estimateMemory() + this.valueWriter.estimateMemory();
    }

    @Override
    public long getRawDataSize() {
        return this.keyWriter.getRawDataSize() + this.valueWriter.getRawDataSize();
    }

    @Override
    public void writeFileStatistics(OrcProto.Footer.Builder footer) {
        super.writeFileStatistics(footer);
        this.keyWriter.writeFileStatistics(footer);
        this.valueWriter.writeFileStatistics(footer);
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.lengths.flush();
        this.keyWriter.flushStreams();
        this.valueWriter.flushStreams();
    }
}

