/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types.transport;

import java.util.Collections;
import java.util.Map;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;

public final class ErrorCondition {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(29L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:error:list");
    private final Symbol condition;
    private final String description;
    private final Map<Symbol, Object> info;

    public ErrorCondition(String condition, String description) {
        this(Symbol.valueOf(condition), description, null);
    }

    public ErrorCondition(Symbol condition, String description) {
        this(condition, description, null);
    }

    public ErrorCondition(Symbol condition, String description, Map<Symbol, Object> info) {
        this.condition = condition;
        this.description = description;
        this.info = info != null ? Collections.unmodifiableMap(info) : null;
    }

    public Symbol getCondition() {
        return this.condition;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<Symbol, Object> getInfo() {
        return this.info;
    }

    public ErrorCondition copy() {
        return new ErrorCondition(this.condition, this.description, this.info);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorCondition that = (ErrorCondition)o;
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        return !(this.info != null ? !this.info.equals(that.info) : that.info != null);
    }

    public int hashCode() {
        int result = this.condition != null ? this.condition.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.info != null ? this.info.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Error{condition=" + String.valueOf(this.condition) + ", description='" + this.description + "', info=" + String.valueOf(this.info) + "}";
    }
}

