/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.messaging;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.Encoder;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedInteger;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Target;
import org.apache.qpid.protonj2.types.messaging.TerminusDurability;
import org.apache.qpid.protonj2.types.messaging.TerminusExpiryPolicy;

public final class TargetTypeEncoder
extends AbstractDescribedListTypeEncoder<Target> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Target.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Target.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Target> getTypeClass() {
        return Target.class;
    }

    @Override
    public void writeElement(Target target, int index, ProtonBuffer buffer, Encoder encoder, EncoderState state) {
        switch (index) {
            case 0: {
                encoder.writeString(buffer, state, target.getAddress());
                break;
            }
            case 1: {
                encoder.writeUnsignedInteger(buffer, state, target.getDurable().getValue());
                break;
            }
            case 2: {
                encoder.writeSymbol(buffer, state, target.getExpiryPolicy().getPolicy());
                break;
            }
            case 3: {
                encoder.writeUnsignedInteger(buffer, state, target.getTimeout());
                break;
            }
            case 4: {
                buffer.writeByte(target.isDynamic() ? (byte)65 : 66);
                break;
            }
            case 5: {
                encoder.writeMap(buffer, state, target.getDynamicNodeProperties());
                break;
            }
            case 6: {
                encoder.writeArray(buffer, state, target.getCapabilities());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Target value index: " + index);
            }
        }
    }

    @Override
    public byte getListEncoding(Target value) {
        return -48;
    }

    @Override
    public int getElementCount(Target target) {
        if (target.getCapabilities() != null) {
            return 7;
        }
        if (target.getDynamicNodeProperties() != null) {
            return 6;
        }
        if (target.isDynamic()) {
            return 5;
        }
        if (target.getTimeout() != null && !target.getTimeout().equals(UnsignedInteger.ZERO)) {
            return 4;
        }
        if (target.getExpiryPolicy() != null && target.getExpiryPolicy() != TerminusExpiryPolicy.SESSION_END) {
            return 3;
        }
        if (target.getDurable() != null && target.getDurable() != TerminusDurability.NONE) {
            return 2;
        }
        if (target.getAddress() != null) {
            return 1;
        }
        return 0;
    }
}

