# PIP-407: Add a newMessage API to create a message with a schema and transaction

# Background knowledge

Pulsar allows messages to be produced with a schema and with a transaction. The producer API allows for messages to
be created with a schema or with a transaction.

# Motivation

The producer API does not expose a method to publish a message with a schema and transaction. This is a gap in the
public API that can be addressed by adding a new overload that creates a message with a schema and a transaction.

# Goals

Make it possible to produce a message that has a custom schema within a transaction.

## In Scope

Add a new method to the Producer public API, and corresponding implementation, that allows for messages to be created
with a custom schema and a transaction.

## Public-facing Changes

Add a new method to Producer to create a Message that accepts a schema and transaction

### Public API

#### Producer.java

```java
    <V> TypedMessageBuilder<V> newMessage(Schema<V> schema,
                                          Transaction txn);
```

# Backward & Forward Compatibility

Fully compatible.

# Links

* Mailing List discussion thread: https://lists.apache.org/thread/f8n0fbjj67cpzprxd8qp582ncy7hwtdn
* Mailing List voting thread: https://lists.apache.org/thread/15xmf3qb5r252cvmhp5lbyo62bktpwfj
