/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.ClientHttpEndpointBase;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpChannelConnector;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.http.impl.HttpClientConnection;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.metrics.ClientMetrics;

class WebSocketEndpoint
extends ClientHttpEndpointBase<HttpClientConnection> {
    private final int maxPoolSize;
    private final HttpChannelConnector connector;
    private final Deque<Waiter> waiters;
    private int inflightConnections;

    WebSocketEndpoint(ClientMetrics metrics, int maxPoolSize, HttpChannelConnector connector, Runnable dispose) {
        super(metrics, dispose);
        this.maxPoolSize = maxPoolSize;
        this.connector = connector;
        this.waiters = new ArrayDeque<Waiter>();
    }

    private void connect(ContextInternal ctx, final Handler<AsyncResult<HttpClientConnection>> handler) {
        ContextInternal eventLoopContext = ctx.isEventLoopContext() ? ctx : ctx.owner().createEventLoopContext(ctx.nettyEventLoop(), ctx.workerPool(), ctx.classLoader());
        class Listener
        implements Handler<AsyncResult<HttpClientConnection>> {
            Listener() {
            }

            @Override
            public void handle(AsyncResult<HttpClientConnection> ar) {
                if (ar.succeeded()) {
                    HttpClientConnection c = ar.result();
                    if (WebSocketEndpoint.this.incRefCount()) {
                        c.evictionHandler(v -> {
                            WebSocketEndpoint.this.decRefCount();
                            WebSocketEndpoint.this.release();
                        });
                        handler.handle(Future.succeededFuture(c));
                    } else {
                        c.close();
                        handler.handle(Future.failedFuture("Connection closed"));
                    }
                } else {
                    WebSocketEndpoint.this.release();
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        }
        this.connector.httpConnect(eventLoopContext, new Listener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        Waiter h;
        WebSocketEndpoint webSocketEndpoint = this;
        synchronized (webSocketEndpoint) {
            if (--this.inflightConnections > this.maxPoolSize || this.waiters.isEmpty()) {
                return;
            }
            h = this.waiters.poll();
        }
        this.connect(h.context, h.handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAcquire(ContextInternal ctx, Handler<AsyncResult<HttpClientConnection>> handler) {
        WebSocketEndpoint webSocketEndpoint = this;
        synchronized (webSocketEndpoint) {
            if (this.inflightConnections >= this.maxPoolSize) {
                this.waiters.add(new Waiter(handler, ctx));
                return false;
            }
            ++this.inflightConnections;
        }
        return true;
    }

    @Override
    public void requestConnection2(ContextInternal ctx, long timeout, Handler<AsyncResult<HttpClientConnection>> handler) {
        if (this.tryAcquire(ctx, handler)) {
            this.connect(ctx, handler);
        }
    }

    @Override
    void checkExpired() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        WebSocketEndpoint webSocketEndpoint = this;
        synchronized (webSocketEndpoint) {
            this.waiters.forEach(waiter -> waiter.context.runOnContext(v -> waiter.handler.handle(Future.failedFuture("Closed"))));
            this.waiters.clear();
        }
    }

    private static class Waiter {
        final Handler<AsyncResult<HttpClientConnection>> handler;
        final ContextInternal context;

        Waiter(Handler<AsyncResult<HttpClientConnection>> handler, ContextInternal context) {
            this.handler = handler;
            this.context = context;
        }
    }
}

