/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.internal;

import io.opentelemetry.instrumentation.api.internal.cache.Cache;

public final class ClassNames {
    private static final Cache<Class<?>, String> simpleNames = Cache.weak();

    public static String simpleName(Class<?> type) {
        return simpleNames.computeIfAbsent(type, ClassNames::computeSimpleName);
    }

    private static String computeSimpleName(Class<?> type) {
        String pkgName;
        if (!type.isAnonymousClass()) {
            return type.getSimpleName();
        }
        String className = type.getName();
        if (type.getPackage() != null && !(pkgName = type.getPackage().getName()).isEmpty()) {
            className = className.substring(pkgName.length() + 1);
        }
        return className;
    }

    private ClassNames() {
    }
}

