/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public final class AuthenticationFactory {
    public static Authentication token(String token) {
        return DefaultImplementation.getDefaultImplementation().newAuthenticationToken(token);
    }

    public static Authentication token(Supplier<String> tokenSupplier) {
        return DefaultImplementation.getDefaultImplementation().newAuthenticationToken(tokenSupplier);
    }

    public static Authentication TLS(String certFilePath, String keyFilePath) {
        return DefaultImplementation.getDefaultImplementation().newAuthenticationTLS(certFilePath, keyFilePath);
    }

    public static Authentication create(String authPluginClassName, String authParamsString) throws PulsarClientException.UnsupportedAuthenticationException {
        try {
            return DefaultImplementation.getDefaultImplementation().createAuthentication(authPluginClassName, authParamsString);
        }
        catch (Throwable t2) {
            throw new PulsarClientException.UnsupportedAuthenticationException(t2);
        }
    }

    public static Authentication create(String authPluginClassName, Map<String, String> authParams) throws PulsarClientException.UnsupportedAuthenticationException {
        try {
            return DefaultImplementation.getDefaultImplementation().createAuthentication(authPluginClassName, authParams);
        }
        catch (Throwable t2) {
            throw new PulsarClientException.UnsupportedAuthenticationException(t2);
        }
    }
}

