/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.kv;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.apache.bookkeeper.clients.exceptions.InternalServerException;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.bookkeeper.clients.utils.ListenableFutureRpcProcessor;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.stream.proto.kv.rpc.RangeRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.RangeResponse;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;

class RangeRequestProcessor<RespT>
extends ListenableFutureRpcProcessor<RangeRequest, RangeResponse, RespT> {
    private final RangeRequest request;
    private final Function<RangeResponse, RespT> responseFunc;

    public static <T> RangeRequestProcessor<T> of(RangeRequest request, Function<RangeResponse, T> responseFunc, StorageContainerChannel channel, ScheduledExecutorService executor, Backoff.Policy backoffPolicy) {
        return new RangeRequestProcessor<T>(request, responseFunc, channel, executor, backoffPolicy);
    }

    private RangeRequestProcessor(RangeRequest request, Function<RangeResponse, RespT> respFunc, StorageContainerChannel channel, ScheduledExecutorService executor, Backoff.Policy backoffPolicy) {
        super(channel, executor, backoffPolicy);
        this.request = request;
        this.responseFunc = respFunc;
    }

    @Override
    protected RangeRequest createRequest() {
        return this.request;
    }

    @Override
    protected ListenableFuture<RangeResponse> sendRPC(StorageServerChannel rsChannel, RangeRequest request) {
        return rsChannel.getTableService().range(request);
    }

    @Override
    protected RespT processResponse(RangeResponse response) throws Exception {
        if (StatusCode.SUCCESS == response.getHeader().getCode()) {
            return this.responseFunc.apply(response);
        }
        throw new InternalServerException("Encountered internal server exception : code = " + (Object)((Object)response.getHeader().getCode()));
    }
}

