/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;

class LightProtoCodec {
    static final int TAG_TYPE_MASK = 7;
    static final int TAG_TYPE_BITS = 3;
    static final int WIRETYPE_VARINT = 0;
    static final int WIRETYPE_FIXED64 = 1;
    static final int WIRETYPE_LENGTH_DELIMITED = 2;
    static final int WIRETYPE_START_GROUP = 3;
    static final int WIRETYPE_END_GROUP = 4;
    static final int WIRETYPE_FIXED32 = 5;

    private LightProtoCodec() {
    }

    private static int getTagType(int tag) {
        return tag & 7;
    }

    static int getFieldId(int tag) {
        return tag >>> 3;
    }

    static void writeVarInt(ByteBuf b, int n) {
        if (n >= 0) {
            LightProtoCodec._writeVarInt(b, n);
        } else {
            LightProtoCodec.writeVarInt64(b, n);
        }
    }

    static void writeSignedVarInt(ByteBuf b, int n) {
        LightProtoCodec.writeVarInt(b, LightProtoCodec.encodeZigZag32(n));
    }

    static int readSignedVarInt(ByteBuf b) {
        return LightProtoCodec.decodeZigZag32(LightProtoCodec.readVarInt(b));
    }

    static long readSignedVarInt64(ByteBuf b) {
        return LightProtoCodec.decodeZigZag64(LightProtoCodec.readVarInt64(b));
    }

    static void writeFloat(ByteBuf b, float n) {
        LightProtoCodec.writeFixedInt32(b, Float.floatToRawIntBits(n));
    }

    static void writeDouble(ByteBuf b, double n) {
        LightProtoCodec.writeFixedInt64(b, Double.doubleToRawLongBits(n));
    }

    static float readFloat(ByteBuf b) {
        return Float.intBitsToFloat(LightProtoCodec.readFixedInt32(b));
    }

    static double readDouble(ByteBuf b) {
        return Double.longBitsToDouble(LightProtoCodec.readFixedInt64(b));
    }

    private static void _writeVarInt(ByteBuf b, int n) {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                b.writeByte(n);
                return;
            }
            b.writeByte(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    static void writeVarInt64(ByteBuf b, long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                b.writeByte((int)value);
                return;
            }
            b.writeByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    static void writeFixedInt32(ByteBuf b, int n) {
        b.writeIntLE(n);
    }

    static void writeFixedInt64(ByteBuf b, long n) {
        b.writeLongLE(n);
    }

    static int readFixedInt32(ByteBuf b) {
        return b.readIntLE();
    }

    static long readFixedInt64(ByteBuf b) {
        return b.readLongLE();
    }

    static void writeSignedVarInt64(ByteBuf b, long n) {
        LightProtoCodec.writeVarInt64(b, LightProtoCodec.encodeZigZag64(n));
    }

    private static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    private static int decodeZigZag32(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    private static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    static int readVarInt(ByteBuf buf) {
        byte tmp = buf.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = buf.readByte();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = buf.readByte();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = buf.readByte();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = buf.readByte();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (buf.readByte() < 0) continue;
                            return result;
                        }
                        throw new IllegalArgumentException("Encountered a malformed varint.");
                    }
                }
            }
        }
        return result;
    }

    static long readVarInt64(ByteBuf buf) {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = buf.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IllegalArgumentException("Encountered a malformed varint.");
    }

    static int computeSignedVarIntSize(int value) {
        return LightProtoCodec.computeVarUIntSize(LightProtoCodec.encodeZigZag32(value));
    }

    static int computeSignedVarInt64Size(long value) {
        return LightProtoCodec.computeVarInt64Size(LightProtoCodec.encodeZigZag64(value));
    }

    static int computeVarIntSize(int value) {
        if (value < 0) {
            return 10;
        }
        return LightProtoCodec.computeVarUIntSize(value);
    }

    static int computeVarUIntSize(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    static int computeVarInt64Size(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    static int computeStringUTF8Size(String s) {
        return ByteBufUtil.utf8Bytes((CharSequence)s);
    }

    static void writeString(ByteBuf b, String s, int bytesCount) {
        ByteBufUtil.reserveAndWriteUtf8((ByteBuf)b, (CharSequence)s, (int)bytesCount);
    }

    static String readString(ByteBuf b, int index, int len) {
        return b.toString(index, len, StandardCharsets.UTF_8);
    }

    static void skipUnknownField(int tag, ByteBuf buffer) {
        int tagType = LightProtoCodec.getTagType(tag);
        switch (tagType) {
            case 0: {
                LightProtoCodec.readVarInt(buffer);
                break;
            }
            case 1: {
                buffer.skipBytes(8);
                break;
            }
            case 2: {
                int len = LightProtoCodec.readVarInt(buffer);
                buffer.skipBytes(len);
                break;
            }
            case 5: {
                buffer.skipBytes(4);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid unknonwn tag type: " + tagType);
            }
        }
    }

    static final class BytesHolder {
        ByteBuf b;
        int idx;
        int len;

        BytesHolder() {
        }
    }

    static final class StringHolder {
        String s;
        int idx;
        int len;

        StringHolder() {
        }
    }
}

