/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.metadata.PDFAIdentificationValidation;
import org.apache.pdfbox.preflight.metadata.RDFAboutAttributeConcordanceValidation;
import org.apache.pdfbox.preflight.metadata.SynchronizedMetaDataValidation;
import org.apache.pdfbox.preflight.metadata.XpacketParsingException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        try {
            PreflightDocument document = ctx.getDocument();
            byte[] tmp = MetadataValidationProcess.getXpacket(document.getDocument());
            DomXmpParser builder = new DomXmpParser();
            XMPMetadata metadata = builder.parse(tmp);
            ctx.setMetadata(metadata);
            if (metadata.getXpacketBytes() != null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.0.0", "bytes attribute is forbidden"));
            }
            if (metadata.getXpacketEncoding() != null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.0.0", "encoding attribute is forbidden"));
            }
            this.addValidationErrors(ctx, new SynchronizedMetaDataValidation().validateMetadataSynchronization(document, metadata));
            this.addValidationErrors(ctx, new PDFAIdentificationValidation().validatePDFAIdentifer(metadata));
            try {
                new RDFAboutAttributeConcordanceValidation().validateRDFAboutAttributes(metadata);
            }
            catch (RDFAboutAttributeConcordanceValidation.DifferentRDFAboutException e) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.0.1", e.getMessage()));
            }
        }
        catch (XpacketParsingException e) {
            if (e.getError() != null) {
                this.addValidationError(ctx, e.getError());
            } else {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7", "Unexpected error"));
            }
        }
        catch (XmpParsingException e) {
            if (e.getErrorType() == XmpParsingException.ErrorType.NoValueType) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.6", e.getMessage()));
            } else if (e.getErrorType() == XmpParsingException.ErrorType.RequiredProperty) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.5", e.getMessage()));
            } else if (e.getErrorType() == XmpParsingException.ErrorType.InvalidPrefix) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.3", e.getMessage()));
            } else if (e.getErrorType() == XmpParsingException.ErrorType.InvalidType) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("7.1.1", e.getMessage()));
            } else {
                if (e.getErrorType() == XmpParsingException.ErrorType.XpacketBadEnd) {
                    throw new ValidationException("Unable to parse font metadata due to : " + e.getMessage(), e);
                }
                if (e.getErrorType() == XmpParsingException.ErrorType.NoSchema) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("7.3", e.getMessage()));
                } else if (e.getErrorType() == XmpParsingException.ErrorType.InvalidPdfaSchema) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("7.4.1", e.getMessage()));
                } else {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("7.1", e.getMessage()));
                }
            }
        }
        catch (IOException e) {
            throw new ValidationException("Failed while validating", e);
        }
    }

    public static byte[] getXpacket(COSDocument cdocument) throws IOException, XpacketParsingException {
        COSObject catalog = cdocument.getCatalog();
        COSBase cb = catalog.getDictionaryObject(COSName.METADATA);
        if (cb == null) {
            ValidationResult.ValidationError error = new ValidationResult.ValidationError("7.1", "Missing Metadata Key in catalog");
            throw new XpacketParsingException("Failed while retrieving xpacket", error);
        }
        COSDictionary metadataDictionnary = COSUtils.getAsDictionary(cb, cdocument);
        if (metadataDictionnary.getItem(COSName.FILTER) != null) {
            ValidationResult.ValidationError error = new ValidationResult.ValidationError("1.2.7", "Filter specified in metadata dictionary");
            throw new XpacketParsingException("Failed while retrieving xpacket", error);
        }
        PDStream stream = PDStream.createFromCOS((COSBase)metadataDictionnary);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        InputStream is = stream.createInputStream();
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        is.close();
        bos.close();
        return bos.toByteArray();
    }

    protected List<ValidationResult.ValidationError> checkStreamFilterUsage(PDDocument doc) {
        ArrayList<ValidationResult.ValidationError> ve = new ArrayList<ValidationResult.ValidationError>();
        List filters = doc.getDocumentCatalog().getMetadata().getFilters();
        if (filters != null && !filters.isEmpty()) {
            ve.add(new ValidationResult.ValidationError("7", "Using stream filter on metadata dictionary is forbidden"));
        }
        return ve;
    }
}

