/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;

public class EdmBinary
extends SingletonPrimitiveType {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte PAD_DEFAULT = 61;
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final EdmBinary INSTANCE = new EdmBinary();

    public EdmBinary() {
        this.uriPrefix = "binary'";
        this.uriSuffix = "'";
    }

    public static EdmBinary getInstance() {
        return INSTANCE;
    }

    @Override
    public Class<?> getDefaultType() {
        return byte[].class;
    }

    private static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static boolean isBase64(byte octet) {
        return octet == 61 || octet >= 0 && octet < DECODE_TABLE.length && DECODE_TABLE[octet] != -1;
    }

    private static boolean isBase64(byte[] arrayOctet) {
        for (int i = 0; i < arrayOctet.length; ++i) {
            if (EdmBinary.isBase64(arrayOctet[i]) || EdmBinary.isWhiteSpace(arrayOctet[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validate(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) {
        return value == null ? isNullable == null || isNullable.booleanValue() : EdmBinary.isBase64(value.getBytes(UTF_8)) && EdmBinary.validateMaxLength(value, maxLength);
    }

    private static boolean validateMaxLength(String value, Integer maxLength) {
        return maxLength == null ? true : maxLength >= (value.length() - EdmBinary.lineEndingsLength(value)) * 3 / 4 - (value.endsWith("==") ? 2 : (value.endsWith("=") ? 1 : 0));
    }

    private static int lineEndingsLength(String value) {
        int result = 0;
        int index = 0;
        while ((index = value.indexOf(10, index)) >= 0) {
            result += index > 0 && value.charAt(index - 1) == '\r' ? 2 : 1;
            ++index;
        }
        return result;
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        if (value == null || !EdmBinary.isBase64(value.getBytes(UTF_8))) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        if (!EdmBinary.validateMaxLength(value, maxLength)) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' does not match the facets' constraints.");
        }
        byte[] result = Base64.decodeBase64((byte[])value.getBytes(UTF_8));
        if (returnType.isAssignableFrom(byte[].class)) {
            return returnType.cast(result);
        }
        if (returnType.isAssignableFrom(Byte[].class)) {
            Byte[] byteArray = new Byte[result.length];
            for (int i = 0; i < result.length; ++i) {
                byteArray[i] = result[i];
            }
            return returnType.cast(byteArray);
        }
        throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.");
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        byte[] byteArrayValue;
        if (value instanceof byte[]) {
            byteArrayValue = (byte[])value;
        } else if (value instanceof Byte[]) {
            int length = ((Byte[])value).length;
            byteArrayValue = new byte[length];
            for (int i = 0; i < length; ++i) {
                byteArrayValue[i] = ((Byte[])value)[i];
            }
        } else {
            throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
        }
        if (maxLength != null && byteArrayValue.length > maxLength) {
            throw new EdmPrimitiveTypeException("The value '" + value + "' does not match the facets' constraints.");
        }
        return new String(Base64.encodeBase64((byte[])byteArrayValue, (boolean)false), UTF_8);
    }
}

